# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from typing import Optional, Set
from typing_extensions import Self

class ListBudgets200ResponseAllOfBudgetsInner(BaseModel):
    """
    ListBudgets200ResponseAllOfBudgetsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    enabled: Optional[StrictBool] = None
    ref_scope: Optional[StrictStr] = Field(default=None, alias="refScope")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    ref_name: Optional[StrictStr] = Field(default=None, alias="refName")
    period: Optional[StrictStr] = None
    year: Optional[StrictStr] = None
    resource_type: Optional[StrictStr] = Field(default=None, alias="resourceType")
    timezone: Optional[StrictStr] = None
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    interval: Optional[StrictStr] = None
    costs: Optional[List[StrictInt]] = None
    is_fiscal: Optional[StrictBool] = Field(default=None, alias="isFiscal")
    average_cost: Optional[StrictInt] = Field(default=None, alias="averageCost")
    total_cost: Optional[StrictInt] = Field(default=None, alias="totalCost")
    currency: Optional[StrictStr] = None
    rollover: Optional[StrictBool] = None
    warning_limit: Optional[StrictStr] = Field(default=None, alias="warningLimit")
    over_limit: Optional[StrictStr] = Field(default=None, alias="overLimit")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    created_by_id: Optional[StrictInt] = Field(default=None, alias="createdById")
    created_by_name: Optional[StrictStr] = Field(default=None, alias="createdByName")
    updated_by_id: Optional[StrictStr] = Field(default=None, alias="updatedById")
    updated_by_name: Optional[StrictStr] = Field(default=None, alias="updatedByName")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "account", "enabled", "refScope", "refType", "refId", "refName", "period", "year", "resourceType", "timezone", "startDate", "endDate", "interval", "costs", "isFiscal", "averageCost", "totalCost", "currency", "rollover", "warningLimit", "overLimit", "externalId", "internalId", "createdById", "createdByName", "updatedById", "updatedByName", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListBudgets200ResponseAllOfBudgetsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if warning_limit (nullable) is None
        # and model_fields_set contains the field
        if self.warning_limit is None and "warning_limit" in self.model_fields_set:
            _dict['warningLimit'] = None

        # set to None if over_limit (nullable) is None
        # and model_fields_set contains the field
        if self.over_limit is None and "over_limit" in self.model_fields_set:
            _dict['overLimit'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if updated_by_id (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by_id is None and "updated_by_id" in self.model_fields_set:
            _dict['updatedById'] = None

        # set to None if updated_by_name (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by_name is None and "updated_by_name" in self.model_fields_set:
            _dict['updatedByName'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListBudgets200ResponseAllOfBudgetsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "enabled": obj.get("enabled"),
            "refScope": obj.get("refScope"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "refName": obj.get("refName"),
            "period": obj.get("period"),
            "year": obj.get("year"),
            "resourceType": obj.get("resourceType"),
            "timezone": obj.get("timezone"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "interval": obj.get("interval"),
            "costs": obj.get("costs"),
            "isFiscal": obj.get("isFiscal"),
            "averageCost": obj.get("averageCost"),
            "totalCost": obj.get("totalCost"),
            "currency": obj.get("currency"),
            "rollover": obj.get("rollover"),
            "warningLimit": obj.get("warningLimit"),
            "overLimit": obj.get("overLimit"),
            "externalId": obj.get("externalId"),
            "internalId": obj.get("internalId"),
            "createdById": obj.get("createdById"),
            "createdByName": obj.get("createdByName"),
            "updatedById": obj.get("updatedById"),
            "updatedByName": obj.get("updatedByName"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


