# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_clouds200_response_all_of_zones_inner_config_any_of_network_server import ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer
from typing import Optional, Set
from typing_extensions import Self

class ListClouds200ResponseAllOfZonesInnerConfigAnyOf(BaseModel):
    """
    ListClouds200ResponseAllOfZonesInnerConfigAnyOf
    """ # noqa: E501
    api_url: Optional[StrictStr] = Field(default=None, alias="apiUrl")
    username: Optional[StrictStr] = None
    password: Optional[StrictStr] = None
    datacenter: Optional[StrictStr] = None
    cluster: Optional[StrictStr] = None
    resource_pool_id: Optional[StrictStr] = Field(default=None, alias="resourcePoolId")
    resource_pool: Optional[StrictStr] = Field(default=None, alias="resourcePool")
    rpc_mode: Optional[StrictStr] = Field(default=None, alias="rpcMode")
    hide_host_selection: Optional[StrictStr] = Field(default=None, alias="hideHostSelection")
    import_existing: Optional[StrictStr] = Field(default=None, alias="importExisting")
    enable_vnc: Optional[StrictStr] = Field(default=None, alias="enableVnc")
    enable_disk_type_selection: Optional[StrictStr] = Field(default=None, alias="enableDiskTypeSelection")
    enable_network_type_selection: Optional[StrictStr] = Field(default=None, alias="enableNetworkTypeSelection")
    disk_storage_type: Optional[StrictStr] = Field(default=None, alias="diskStorageType")
    appliance_url: Optional[StrictStr] = Field(default=None, alias="applianceUrl")
    datacenter_name: Optional[StrictStr] = Field(default=None, alias="datacenterName")
    network_server_id: Optional[StrictStr] = Field(default=None, alias="networkServer.id")
    network_server: Optional[ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer] = Field(default=None, alias="networkServer")
    security_mode: Optional[StrictStr] = Field(default=None, alias="securityMode")
    certificate_provider: Optional[StrictStr] = Field(default=None, alias="certificateProvider")
    backup_mode: Optional[StrictStr] = Field(default=None, alias="backupMode")
    replication_mode: Optional[StrictStr] = Field(default=None, alias="replicationMode")
    dns_integration_id: Optional[StrictStr] = Field(default=None, alias="dnsIntegrationId")
    config_cmdb_id: Optional[StrictStr] = Field(default=None, alias="configCmdbId")
    config_management_id: Optional[StrictStr] = Field(default=None, alias="configManagementId")
    config_cm_id: Optional[StrictStr] = Field(default=None, alias="configCmId")
    security_server: Optional[StrictStr] = Field(default=None, alias="securityServer")
    service_registry_id: Optional[StrictStr] = Field(default=None, alias="serviceRegistryId")
    kube_url: Optional[StrictStr] = Field(default=None, alias="kubeUrl")
    api_version: Optional[StrictStr] = Field(default=None, alias="apiVersion")
    datacenter_id: Optional[StrictStr] = Field(default=None, alias="datacenterId")
    config_cmdb_discovery: Optional[StrictBool] = Field(default=None, alias="configCmdbDiscovery")
    distributed_worker_id: Optional[StrictStr] = Field(default=None, alias="distributedWorkerId")
    password_hash: Optional[StrictStr] = Field(default=None, alias="passwordHash")
    __properties: ClassVar[List[str]] = ["apiUrl", "username", "password", "datacenter", "cluster", "resourcePoolId", "resourcePool", "rpcMode", "hideHostSelection", "importExisting", "enableVnc", "enableDiskTypeSelection", "enableNetworkTypeSelection", "diskStorageType", "applianceUrl", "datacenterName", "networkServer.id", "networkServer", "securityMode", "certificateProvider", "backupMode", "replicationMode", "dnsIntegrationId", "configCmdbId", "configManagementId", "configCmId", "securityServer", "serviceRegistryId", "kubeUrl", "apiVersion", "datacenterId", "configCmdbDiscovery", "distributedWorkerId", "passwordHash"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClouds200ResponseAllOfZonesInnerConfigAnyOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict['password'] = None

        # set to None if enable_disk_type_selection (nullable) is None
        # and model_fields_set contains the field
        if self.enable_disk_type_selection is None and "enable_disk_type_selection" in self.model_fields_set:
            _dict['enableDiskTypeSelection'] = None

        # set to None if disk_storage_type (nullable) is None
        # and model_fields_set contains the field
        if self.disk_storage_type is None and "disk_storage_type" in self.model_fields_set:
            _dict['diskStorageType'] = None

        # set to None if appliance_url (nullable) is None
        # and model_fields_set contains the field
        if self.appliance_url is None and "appliance_url" in self.model_fields_set:
            _dict['applianceUrl'] = None

        # set to None if datacenter_name (nullable) is None
        # and model_fields_set contains the field
        if self.datacenter_name is None and "datacenter_name" in self.model_fields_set:
            _dict['datacenterName'] = None

        # set to None if certificate_provider (nullable) is None
        # and model_fields_set contains the field
        if self.certificate_provider is None and "certificate_provider" in self.model_fields_set:
            _dict['certificateProvider'] = None

        # set to None if backup_mode (nullable) is None
        # and model_fields_set contains the field
        if self.backup_mode is None and "backup_mode" in self.model_fields_set:
            _dict['backupMode'] = None

        # set to None if replication_mode (nullable) is None
        # and model_fields_set contains the field
        if self.replication_mode is None and "replication_mode" in self.model_fields_set:
            _dict['replicationMode'] = None

        # set to None if dns_integration_id (nullable) is None
        # and model_fields_set contains the field
        if self.dns_integration_id is None and "dns_integration_id" in self.model_fields_set:
            _dict['dnsIntegrationId'] = None

        # set to None if config_cmdb_id (nullable) is None
        # and model_fields_set contains the field
        if self.config_cmdb_id is None and "config_cmdb_id" in self.model_fields_set:
            _dict['configCmdbId'] = None

        # set to None if config_management_id (nullable) is None
        # and model_fields_set contains the field
        if self.config_management_id is None and "config_management_id" in self.model_fields_set:
            _dict['configManagementId'] = None

        # set to None if config_cm_id (nullable) is None
        # and model_fields_set contains the field
        if self.config_cm_id is None and "config_cm_id" in self.model_fields_set:
            _dict['configCmId'] = None

        # set to None if security_server (nullable) is None
        # and model_fields_set contains the field
        if self.security_server is None and "security_server" in self.model_fields_set:
            _dict['securityServer'] = None

        # set to None if service_registry_id (nullable) is None
        # and model_fields_set contains the field
        if self.service_registry_id is None and "service_registry_id" in self.model_fields_set:
            _dict['serviceRegistryId'] = None

        # set to None if kube_url (nullable) is None
        # and model_fields_set contains the field
        if self.kube_url is None and "kube_url" in self.model_fields_set:
            _dict['kubeUrl'] = None

        # set to None if api_version (nullable) is None
        # and model_fields_set contains the field
        if self.api_version is None and "api_version" in self.model_fields_set:
            _dict['apiVersion'] = None

        # set to None if datacenter_id (nullable) is None
        # and model_fields_set contains the field
        if self.datacenter_id is None and "datacenter_id" in self.model_fields_set:
            _dict['datacenterId'] = None

        # set to None if distributed_worker_id (nullable) is None
        # and model_fields_set contains the field
        if self.distributed_worker_id is None and "distributed_worker_id" in self.model_fields_set:
            _dict['distributedWorkerId'] = None

        # set to None if password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.password_hash is None and "password_hash" in self.model_fields_set:
            _dict['passwordHash'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClouds200ResponseAllOfZonesInnerConfigAnyOf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "apiUrl": obj.get("apiUrl"),
            "username": obj.get("username"),
            "password": obj.get("password"),
            "datacenter": obj.get("datacenter"),
            "cluster": obj.get("cluster"),
            "resourcePoolId": obj.get("resourcePoolId"),
            "resourcePool": obj.get("resourcePool"),
            "rpcMode": obj.get("rpcMode"),
            "hideHostSelection": obj.get("hideHostSelection"),
            "importExisting": obj.get("importExisting"),
            "enableVnc": obj.get("enableVnc"),
            "enableDiskTypeSelection": obj.get("enableDiskTypeSelection"),
            "enableNetworkTypeSelection": obj.get("enableNetworkTypeSelection"),
            "diskStorageType": obj.get("diskStorageType"),
            "applianceUrl": obj.get("applianceUrl"),
            "datacenterName": obj.get("datacenterName"),
            "networkServer.id": obj.get("networkServer.id"),
            "networkServer": ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None,
            "securityMode": obj.get("securityMode"),
            "certificateProvider": obj.get("certificateProvider"),
            "backupMode": obj.get("backupMode"),
            "replicationMode": obj.get("replicationMode"),
            "dnsIntegrationId": obj.get("dnsIntegrationId"),
            "configCmdbId": obj.get("configCmdbId"),
            "configManagementId": obj.get("configManagementId"),
            "configCmId": obj.get("configCmId"),
            "securityServer": obj.get("securityServer"),
            "serviceRegistryId": obj.get("serviceRegistryId"),
            "kubeUrl": obj.get("kubeUrl"),
            "apiVersion": obj.get("apiVersion"),
            "datacenterId": obj.get("datacenterId"),
            "configCmdbDiscovery": obj.get("configCmdbDiscovery"),
            "distributedWorkerId": obj.get("distributedWorkerId"),
            "passwordHash": obj.get("passwordHash")
        })
        return _obj


