# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListClusterServices200ResponseAllOfServicesInner(BaseModel):
    """
    ListClusterServices200ResponseAllOfServicesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    external_ip: Optional[StrictStr] = Field(default=None, alias="externalIp")
    internal_ip: Optional[StrictStr] = Field(default=None, alias="internalIp")
    external_port: Optional[StrictStr] = Field(default=None, alias="externalPort")
    internal_port: Optional[StrictStr] = Field(default=None, alias="internalPort")
    status: Optional[StrictStr] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "name", "type", "code", "externalIp", "internalIp", "externalPort", "internalPort", "status", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClusterServices200ResponseAllOfServicesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if type (nullable) is None
        # and model_fields_set contains the field
        if self.type is None and "type" in self.model_fields_set:
            _dict['type'] = None

        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if external_ip (nullable) is None
        # and model_fields_set contains the field
        if self.external_ip is None and "external_ip" in self.model_fields_set:
            _dict['externalIp'] = None

        # set to None if internal_ip (nullable) is None
        # and model_fields_set contains the field
        if self.internal_ip is None and "internal_ip" in self.model_fields_set:
            _dict['internalIp'] = None

        # set to None if external_port (nullable) is None
        # and model_fields_set contains the field
        if self.external_port is None and "external_port" in self.model_fields_set:
            _dict['externalPort'] = None

        # set to None if internal_port (nullable) is None
        # and model_fields_set contains the field
        if self.internal_port is None and "internal_port" in self.model_fields_set:
            _dict['internalPort'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if date_created (nullable) is None
        # and model_fields_set contains the field
        if self.date_created is None and "date_created" in self.model_fields_set:
            _dict['dateCreated'] = None

        # set to None if last_updated (nullable) is None
        # and model_fields_set contains the field
        if self.last_updated is None and "last_updated" in self.model_fields_set:
            _dict['lastUpdated'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClusterServices200ResponseAllOfServicesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "type": obj.get("type"),
            "code": obj.get("code"),
            "externalIp": obj.get("externalIp"),
            "internalIp": obj.get("internalIp"),
            "externalPort": obj.get("externalPort"),
            "internalPort": obj.get("internalPort"),
            "status": obj.get("status"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


