# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_clusters200_response_all_of_clusters_inner_servers_inner_compute_server_type import ListClusters200ResponseAllOfClustersInnerServersInnerComputeServerType
from typing import Optional, Set
from typing_extensions import Self

class ListClusters200ResponseAllOfClustersInnerServersInner(BaseModel):
    """
    ListClusters200ResponseAllOfClustersInnerServersInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    type_set: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="typeSet")
    compute_server_type: Optional[ListClusters200ResponseAllOfClustersInnerServersInnerComputeServerType] = Field(default=None, alias="computeServerType")
    __properties: ClassVar[List[str]] = ["id", "name", "typeSet", "computeServerType"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListClusters200ResponseAllOfClustersInnerServersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type_set
        if self.type_set:
            _dict['typeSet'] = self.type_set.to_dict()
        # override the default output from pydantic by calling `to_dict()` of compute_server_type
        if self.compute_server_type:
            _dict['computeServerType'] = self.compute_server_type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListClusters200ResponseAllOfClustersInnerServersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "typeSet": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["typeSet"]) if obj.get("typeSet") is not None else None,
            "computeServerType": ListClusters200ResponseAllOfClustersInnerServersInnerComputeServerType.from_dict(obj["computeServerType"]) if obj.get("computeServerType") is not None else None
        })
        return _obj


