# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_activity200_response_all_of_meta import ListActivity200ResponseAllOfMeta
from morpheus.models.list_cypher_keys200_response_all_of_cyphers_inner import ListCypherKeys200ResponseAllOfCyphersInner
from morpheus.models.list_cypher_keys200_response_all_of_data import ListCypherKeys200ResponseAllOfData
from typing import Optional, Set
from typing_extensions import Self

class ListCypherKeys200Response(BaseModel):
    """
    ListCypherKeys200Response
    """ # noqa: E501
    data: Optional[ListCypherKeys200ResponseAllOfData] = None
    cyphers: Optional[List[ListCypherKeys200ResponseAllOfCyphersInner]] = None
    meta: Optional[ListActivity200ResponseAllOfMeta] = None
    success: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["data", "cyphers", "meta", "success"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListCypherKeys200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in cyphers (list)
        _items = []
        if self.cyphers:
            for _item_cyphers in self.cyphers:
                if _item_cyphers:
                    _items.append(_item_cyphers.to_dict())
            _dict['cyphers'] = _items
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListCypherKeys200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "data": ListCypherKeys200ResponseAllOfData.from_dict(obj["data"]) if obj.get("data") is not None else None,
            "cyphers": [ListCypherKeys200ResponseAllOfCyphersInner.from_dict(_item) for _item in obj["cyphers"]] if obj.get("cyphers") is not None else None,
            "meta": ListActivity200ResponseAllOfMeta.from_dict(obj["meta"]) if obj.get("meta") is not None else None,
            "success": obj.get("success")
        })
        return _obj


