# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from morpheus.models.list_health200_response_all_of_health_database_innodb_stats import ListHealth200ResponseAllOfHealthDatabaseInnodbStats
from morpheus.models.list_health200_response_all_of_health_database_scans import ListHealth200ResponseAllOfHealthDatabaseScans
from morpheus.models.list_health200_response_all_of_health_database_slow_queries_inner import ListHealth200ResponseAllOfHealthDatabaseSlowQueriesInner
from morpheus.models.list_health200_response_all_of_health_database_stats import ListHealth200ResponseAllOfHealthDatabaseStats
from typing import Optional, Set
from typing_extensions import Self

class ListHealth200ResponseAllOfHealthDatabase(BaseModel):
    """
    ListHealth200ResponseAllOfHealthDatabase
    """ # noqa: E501
    success: Optional[StrictBool] = None
    connection_list: Optional[List[Dict[str, Any]]] = Field(default=None, alias="connectionList")
    busy_connections: Optional[List[Optional[StrictStr]]] = Field(default=None, alias="busyConnections")
    max_connections: Optional[StrictInt] = Field(default=None, alias="maxConnections")
    max_used_connections: Optional[StrictInt] = Field(default=None, alias="maxUsedConnections")
    used_connections: Optional[StrictInt] = Field(default=None, alias="usedConnections")
    aborted_connections: Optional[StrictInt] = Field(default=None, alias="abortedConnections")
    innodb_status: Optional[StrictStr] = Field(default=None, alias="innodbStatus")
    stats: Optional[ListHealth200ResponseAllOfHealthDatabaseStats] = None
    scans: Optional[ListHealth200ResponseAllOfHealthDatabaseScans] = None
    slow_queries: Optional[List[ListHealth200ResponseAllOfHealthDatabaseSlowQueriesInner]] = Field(default=None, alias="slowQueries")
    innodb_stats: Optional[ListHealth200ResponseAllOfHealthDatabaseInnodbStats] = Field(default=None, alias="innodbStats")
    scan_percent: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="scanPercent")
    status: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["success", "connectionList", "busyConnections", "maxConnections", "maxUsedConnections", "usedConnections", "abortedConnections", "innodbStatus", "stats", "scans", "slowQueries", "innodbStats", "scanPercent", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthDatabase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of stats
        if self.stats:
            _dict['stats'] = self.stats.to_dict()
        # override the default output from pydantic by calling `to_dict()` of scans
        if self.scans:
            _dict['scans'] = self.scans.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in slow_queries (list)
        _items = []
        if self.slow_queries:
            for _item_slow_queries in self.slow_queries:
                if _item_slow_queries:
                    _items.append(_item_slow_queries.to_dict())
            _dict['slowQueries'] = _items
        # override the default output from pydantic by calling `to_dict()` of innodb_stats
        if self.innodb_stats:
            _dict['innodbStats'] = self.innodb_stats.to_dict()
        # set to None if connection_list (nullable) is None
        # and model_fields_set contains the field
        if self.connection_list is None and "connection_list" in self.model_fields_set:
            _dict['connectionList'] = None

        # set to None if innodb_status (nullable) is None
        # and model_fields_set contains the field
        if self.innodb_status is None and "innodb_status" in self.model_fields_set:
            _dict['innodbStatus'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthDatabase from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "success": obj.get("success"),
            "connectionList": obj.get("connectionList"),
            "busyConnections": obj.get("busyConnections"),
            "maxConnections": obj.get("maxConnections"),
            "maxUsedConnections": obj.get("maxUsedConnections"),
            "usedConnections": obj.get("usedConnections"),
            "abortedConnections": obj.get("abortedConnections"),
            "innodbStatus": obj.get("innodbStatus"),
            "stats": ListHealth200ResponseAllOfHealthDatabaseStats.from_dict(obj["stats"]) if obj.get("stats") is not None else None,
            "scans": ListHealth200ResponseAllOfHealthDatabaseScans.from_dict(obj["scans"]) if obj.get("scans") is not None else None,
            "slowQueries": [ListHealth200ResponseAllOfHealthDatabaseSlowQueriesInner.from_dict(_item) for _item in obj["slowQueries"]] if obj.get("slowQueries") is not None else None,
            "innodbStats": ListHealth200ResponseAllOfHealthDatabaseInnodbStats.from_dict(obj["innodbStats"]) if obj.get("innodbStats") is not None else None,
            "scanPercent": obj.get("scanPercent"),
            "status": obj.get("status")
        })
        return _obj


