# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_health200_response_all_of_health_rabbit_queues_inner import ListHealth200ResponseAllOfHealthRabbitQueuesInner
from typing import Optional, Set
from typing_extensions import Self

class ListHealth200ResponseAllOfHealthRabbit(BaseModel):
    """
    ListHealth200ResponseAllOfHealthRabbit
    """ # noqa: E501
    success: Optional[StrictBool] = None
    busy_queues: Optional[List[Dict[str, Any]]] = Field(default=None, alias="busyQueues")
    error_queues: Optional[List[Dict[str, Any]]] = Field(default=None, alias="errorQueues")
    status: Optional[StrictStr] = None
    queues: Optional[List[ListHealth200ResponseAllOfHealthRabbitQueuesInner]] = None
    __properties: ClassVar[List[str]] = ["success", "busyQueues", "errorQueues", "status", "queues"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthRabbit from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in queues (list)
        _items = []
        if self.queues:
            for _item_queues in self.queues:
                if _item_queues:
                    _items.append(_item_queues.to_dict())
            _dict['queues'] = _items
        # set to None if busy_queues (nullable) is None
        # and model_fields_set contains the field
        if self.busy_queues is None and "busy_queues" in self.model_fields_set:
            _dict['busyQueues'] = None

        # set to None if error_queues (nullable) is None
        # and model_fields_set contains the field
        if self.error_queues is None and "error_queues" in self.model_fields_set:
            _dict['errorQueues'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListHealth200ResponseAllOfHealthRabbit from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "success": obj.get("success"),
            "busyQueues": obj.get("busyQueues"),
            "errorQueues": obj.get("errorQueues"),
            "status": obj.get("status"),
            "queues": [ListHealth200ResponseAllOfHealthRabbitQueuesInner.from_dict(_item) for _item in obj["queues"]] if obj.get("queues") is not None else None
        })
        return _obj


