# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_host_devices200_response_devices_inner_type import ListHostDevices200ResponseDevicesInnerType
from typing import Optional, Set
from typing_extensions import Self

class ListHostDevices200ResponseDevicesInner(BaseModel):
    """
    ListHostDevices200ResponseDevicesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, description="(Assignee) Target Server ID", alias="refId")
    status: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    domain_id: Optional[StrictInt] = Field(default=None, alias="domainId")
    bus: Optional[StrictInt] = None
    slot: Optional[StrictInt] = None
    device: Optional[StrictInt] = None
    vendor_id: Optional[StrictStr] = Field(default=None, alias="vendorId")
    product_id: Optional[StrictStr] = Field(default=None, alias="productId")
    function_id: Optional[StrictInt] = Field(default=None, alias="functionId")
    unique_id: Optional[StrictStr] = Field(default=None, alias="uniqueId")
    iommu_group: Optional[StrictInt] = Field(default=None, alias="iommuGroup")
    iommu_device_count: Optional[StrictInt] = Field(default=None, alias="iommuDeviceCount")
    type: Optional[ListHostDevices200ResponseDevicesInnerType] = None
    __properties: ClassVar[List[str]] = ["id", "name", "refType", "refId", "status", "externalId", "domainId", "bus", "slot", "device", "vendorId", "productId", "functionId", "uniqueId", "iommuGroup", "iommuDeviceCount", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListHostDevices200ResponseDevicesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if domain_id (nullable) is None
        # and model_fields_set contains the field
        if self.domain_id is None and "domain_id" in self.model_fields_set:
            _dict['domainId'] = None

        # set to None if bus (nullable) is None
        # and model_fields_set contains the field
        if self.bus is None and "bus" in self.model_fields_set:
            _dict['bus'] = None

        # set to None if slot (nullable) is None
        # and model_fields_set contains the field
        if self.slot is None and "slot" in self.model_fields_set:
            _dict['slot'] = None

        # set to None if device (nullable) is None
        # and model_fields_set contains the field
        if self.device is None and "device" in self.model_fields_set:
            _dict['device'] = None

        # set to None if vendor_id (nullable) is None
        # and model_fields_set contains the field
        if self.vendor_id is None and "vendor_id" in self.model_fields_set:
            _dict['vendorId'] = None

        # set to None if product_id (nullable) is None
        # and model_fields_set contains the field
        if self.product_id is None and "product_id" in self.model_fields_set:
            _dict['productId'] = None

        # set to None if function_id (nullable) is None
        # and model_fields_set contains the field
        if self.function_id is None and "function_id" in self.model_fields_set:
            _dict['functionId'] = None

        # set to None if unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.unique_id is None and "unique_id" in self.model_fields_set:
            _dict['uniqueId'] = None

        # set to None if iommu_group (nullable) is None
        # and model_fields_set contains the field
        if self.iommu_group is None and "iommu_group" in self.model_fields_set:
            _dict['iommuGroup'] = None

        # set to None if iommu_device_count (nullable) is None
        # and model_fields_set contains the field
        if self.iommu_device_count is None and "iommu_device_count" in self.model_fields_set:
            _dict['iommuDeviceCount'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListHostDevices200ResponseDevicesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "status": obj.get("status"),
            "externalId": obj.get("externalId"),
            "domainId": obj.get("domainId"),
            "bus": obj.get("bus"),
            "slot": obj.get("slot"),
            "device": obj.get("device"),
            "vendorId": obj.get("vendorId"),
            "productId": obj.get("productId"),
            "functionId": obj.get("functionId"),
            "uniqueId": obj.get("uniqueId"),
            "iommuGroup": obj.get("iommuGroup"),
            "iommuDeviceCount": obj.get("iommuDeviceCount"),
            "type": ListHostDevices200ResponseDevicesInnerType.from_dict(obj["type"]) if obj.get("type") is not None else None
        })
        return _obj


