# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListHostDevices200ResponseDevicesInnerType(BaseModel):
    """
    ListHostDevices200ResponseDevicesInnerType
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    family: Optional[StrictStr] = None
    bus_type: Optional[StrictStr] = Field(default=None, alias="busType")
    assignable: Optional[StrictBool] = None
    hotpluggable: Optional[StrictBool] = None
    vendor_id: Optional[StrictInt] = Field(default=None, alias="vendorId")
    product_id: Optional[StrictInt] = Field(default=None, alias="productId")
    __properties: ClassVar[List[str]] = ["id", "name", "family", "busType", "assignable", "hotpluggable", "vendorId", "productId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListHostDevices200ResponseDevicesInnerType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if family (nullable) is None
        # and model_fields_set contains the field
        if self.family is None and "family" in self.model_fields_set:
            _dict['family'] = None

        # set to None if bus_type (nullable) is None
        # and model_fields_set contains the field
        if self.bus_type is None and "bus_type" in self.model_fields_set:
            _dict['busType'] = None

        # set to None if vendor_id (nullable) is None
        # and model_fields_set contains the field
        if self.vendor_id is None and "vendor_id" in self.model_fields_set:
            _dict['vendorId'] = None

        # set to None if product_id (nullable) is None
        # and model_fields_set contains the field
        if self.product_id is None and "product_id" in self.model_fields_set:
            _dict['productId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListHostDevices200ResponseDevicesInnerType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "family": obj.get("family"),
            "busType": obj.get("busType"),
            "assignable": obj.get("assignable"),
            "hotpluggable": obj.get("hotpluggable"),
            "vendorId": obj.get("vendorId"),
            "productId": obj.get("productId")
        })
        return _obj


