# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_identity_sources200_response_all_of_user_sources_inner_any_of_default_account_role import ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOfDefaultAccountRole
from typing import Optional, Set
from typing_extensions import Self

class ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf1RoleMappingsInner(BaseModel):
    """
    ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf1RoleMappingsInner
    """ # noqa: E501
    source_role_name: Optional[StrictStr] = Field(default=None, alias="sourceRoleName")
    source_role_fqn: Optional[StrictStr] = Field(default=None, alias="sourceRoleFqn")
    mapped_role: Optional[ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOfDefaultAccountRole] = Field(default=None, alias="mappedRole")
    __properties: ClassVar[List[str]] = ["sourceRoleName", "sourceRoleFqn", "mappedRole"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf1RoleMappingsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of mapped_role
        if self.mapped_role:
            _dict['mappedRole'] = self.mapped_role.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf1RoleMappingsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sourceRoleName": obj.get("sourceRoleName"),
            "sourceRoleFqn": obj.get("sourceRoleFqn"),
            "mappedRole": ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOfDefaultAccountRole.from_dict(obj["mappedRole"]) if obj.get("mappedRole") is not None else None
        })
        return _obj


