# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf6Config(BaseModel):
    """
    ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf6Config
    """ # noqa: E501
    url: Optional[StrictStr] = None
    logout_url: Optional[StrictStr] = Field(default=None, alias="logoutUrl")
    do_not_include_saml_request: Optional[StrictBool] = Field(default=None, alias="doNotIncludeSAMLRequest")
    saml_signature_mode: Optional[StrictStr] = Field(default=None, alias="SAMLSignatureMode")
    do_not_validate_signature: Optional[StrictBool] = Field(default=None, alias="doNotValidateSignature")
    do_not_validate_status_code: Optional[StrictBool] = Field(default=None, alias="doNotValidateStatusCode")
    do_not_validate_destination: Optional[StrictBool] = Field(default=None, alias="doNotValidateDestination")
    do_not_validate_issue_instants: Optional[StrictBool] = Field(default=None, alias="doNotValidateIssueInstants")
    do_not_validate_assertions: Optional[StrictBool] = Field(default=None, alias="doNotValidateAssertions")
    given_name_attribute: Optional[StrictStr] = Field(default=None, alias="givenNameAttribute")
    surname_attribute: Optional[StrictStr] = Field(default=None, alias="surnameAttribute")
    email_attribute: Optional[StrictStr] = Field(default=None, alias="emailAttribute")
    required_attribute_value: Optional[StrictStr] = Field(default=None, alias="requiredAttributeValue")
    role_attribute_name: Optional[StrictStr] = Field(default=None, alias="roleAttributeName")
    azure_tenant_id: Optional[StrictStr] = Field(default=None, alias="azureTenantId")
    azure_app_id: Optional[StrictStr] = Field(default=None, alias="azureAppId")
    azure_app_secret: Optional[StrictStr] = Field(default=None, alias="azureAppSecret")
    role_link_attribute_name: Optional[StrictStr] = Field(default=None, alias="roleLinkAttributeName")
    public_key: Optional[StrictStr] = Field(default=None, alias="publicKey")
    azure_app_secret_hash: Optional[StrictStr] = Field(default=None, alias="azureAppSecretHash")
    __properties: ClassVar[List[str]] = ["url", "logoutUrl", "doNotIncludeSAMLRequest", "SAMLSignatureMode", "doNotValidateSignature", "doNotValidateStatusCode", "doNotValidateDestination", "doNotValidateIssueInstants", "doNotValidateAssertions", "givenNameAttribute", "surnameAttribute", "emailAttribute", "requiredAttributeValue", "roleAttributeName", "azureTenantId", "azureAppId", "azureAppSecret", "roleLinkAttributeName", "publicKey", "azureAppSecretHash"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf6Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if azure_app_secret (nullable) is None
        # and model_fields_set contains the field
        if self.azure_app_secret is None and "azure_app_secret" in self.model_fields_set:
            _dict['azureAppSecret'] = None

        # set to None if azure_app_secret_hash (nullable) is None
        # and model_fields_set contains the field
        if self.azure_app_secret_hash is None and "azure_app_secret_hash" in self.model_fields_set:
            _dict['azureAppSecretHash'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListIdentitySources200ResponseAllOfUserSourcesInnerAnyOf6Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "url": obj.get("url"),
            "logoutUrl": obj.get("logoutUrl"),
            "doNotIncludeSAMLRequest": obj.get("doNotIncludeSAMLRequest"),
            "SAMLSignatureMode": obj.get("SAMLSignatureMode"),
            "doNotValidateSignature": obj.get("doNotValidateSignature"),
            "doNotValidateStatusCode": obj.get("doNotValidateStatusCode"),
            "doNotValidateDestination": obj.get("doNotValidateDestination"),
            "doNotValidateIssueInstants": obj.get("doNotValidateIssueInstants"),
            "doNotValidateAssertions": obj.get("doNotValidateAssertions"),
            "givenNameAttribute": obj.get("givenNameAttribute"),
            "surnameAttribute": obj.get("surnameAttribute"),
            "emailAttribute": obj.get("emailAttribute"),
            "requiredAttributeValue": obj.get("requiredAttributeValue"),
            "roleAttributeName": obj.get("roleAttributeName"),
            "azureTenantId": obj.get("azureTenantId"),
            "azureAppId": obj.get("azureAppId"),
            "azureAppSecret": obj.get("azureAppSecret"),
            "roleLinkAttributeName": obj.get("roleLinkAttributeName"),
            "publicKey": obj.get("publicKey"),
            "azureAppSecretHash": obj.get("azureAppSecretHash")
        })
        return _obj


