# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_activity200_response_all_of_meta import ListActivity200ResponseAllOfMeta
from morpheus.models.list_image_builds200_response_all_of_image_builds_inner import ListImageBuilds200ResponseAllOfImageBuildsInner
from typing import Optional, Set
from typing_extensions import Self

class ListImageBuilds200Response(BaseModel):
    """
    ListImageBuilds200Response
    """ # noqa: E501
    image_builds: Optional[List[ListImageBuilds200ResponseAllOfImageBuildsInner]] = Field(default=None, alias="imageBuilds")
    image_build_count: Optional[StrictInt] = Field(default=None, alias="imageBuildCount")
    meta: Optional[ListActivity200ResponseAllOfMeta] = None
    __properties: ClassVar[List[str]] = ["imageBuilds", "imageBuildCount", "meta"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListImageBuilds200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in image_builds (list)
        _items = []
        if self.image_builds:
            for _item_image_builds in self.image_builds:
                if _item_image_builds:
                    _items.append(_item_image_builds.to_dict())
            _dict['imageBuilds'] = _items
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListImageBuilds200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "imageBuilds": [ListImageBuilds200ResponseAllOfImageBuildsInner.from_dict(_item) for _item in obj["imageBuilds"]] if obj.get("imageBuilds") is not None else None,
            "imageBuildCount": obj.get("imageBuildCount"),
            "meta": ListActivity200ResponseAllOfMeta.from_dict(obj["meta"]) if obj.get("meta") is not None else None
        })
        return _obj


