# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_integrations200_response_any_of_integrations_inner_any_of14_config import ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf14Config
from morpheus.models.list_integrations200_response_any_of_integrations_inner_any_of_credential import ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential
from typing import Optional, Set
from typing_extensions import Self

class ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf14(BaseModel):
    """
    ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf14
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    type: Optional[StrictStr] = None
    integration_type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = Field(default=None, alias="integrationType")
    url: Optional[StrictStr] = None
    port: Optional[StrictStr] = None
    username: Optional[StrictStr] = None
    password: Optional[StrictStr] = None
    password_hash: Optional[StrictStr] = Field(default=None, alias="passwordHash")
    path: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    windows_version: Optional[StrictStr] = Field(default=None, alias="windowsVersion")
    repo_url: Optional[StrictStr] = Field(default=None, alias="repoUrl")
    service_mode: Optional[StrictStr] = Field(default=None, alias="serviceMode")
    is_plugin: Optional[StrictBool] = Field(default=None, alias="isPlugin")
    config: Optional[ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf14Config] = None
    status: Optional[StrictStr] = None
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    last_sync: Optional[StrictStr] = Field(default=None, alias="lastSync")
    last_sync_duration: Optional[StrictStr] = Field(default=None, alias="lastSyncDuration")
    credential: Optional[ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential] = None
    __properties: ClassVar[List[str]] = ["id", "name", "enabled", "type", "integrationType", "url", "port", "username", "password", "passwordHash", "path", "version", "windowsVersion", "repoUrl", "serviceMode", "isPlugin", "config", "status", "statusDate", "statusMessage", "lastSync", "lastSyncDuration", "credential"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['saltMaster']):
            raise ValueError("must be one of enum values ('saltMaster')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf14 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of integration_type
        if self.integration_type:
            _dict['integrationType'] = self.integration_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # set to None if last_sync (nullable) is None
        # and model_fields_set contains the field
        if self.last_sync is None and "last_sync" in self.model_fields_set:
            _dict['lastSync'] = None

        # set to None if last_sync_duration (nullable) is None
        # and model_fields_set contains the field
        if self.last_sync_duration is None and "last_sync_duration" in self.model_fields_set:
            _dict['lastSyncDuration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf14 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "enabled": obj.get("enabled"),
            "type": obj.get("type"),
            "integrationType": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["integrationType"]) if obj.get("integrationType") is not None else None,
            "url": obj.get("url"),
            "port": obj.get("port"),
            "username": obj.get("username"),
            "password": obj.get("password"),
            "passwordHash": obj.get("passwordHash"),
            "path": obj.get("path"),
            "version": obj.get("version"),
            "windowsVersion": obj.get("windowsVersion"),
            "repoUrl": obj.get("repoUrl"),
            "serviceMode": obj.get("serviceMode"),
            "isPlugin": obj.get("isPlugin"),
            "config": ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf14Config.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "status": obj.get("status"),
            "statusDate": obj.get("statusDate"),
            "statusMessage": obj.get("statusMessage"),
            "lastSync": obj.get("lastSync"),
            "lastSyncDuration": obj.get("lastSyncDuration"),
            "credential": ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None
        })
        return _obj


