# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_integrations200_response_any_of_integrations_inner_any_of2_config_zones_inner import ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf2ConfigZonesInner
from typing import Optional, Set
from typing_extensions import Self

class ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf2Config(BaseModel):
    """
    ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf2Config
    """ # noqa: E501
    zones: Optional[List[ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf2ConfigZonesInner]] = None
    __properties: ClassVar[List[str]] = ["zones"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf2Config from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in zones (list)
        _items = []
        if self.zones:
            for _item_zones in self.zones:
                if _item_zones:
                    _items.append(_item_zones.to_dict())
            _dict['zones'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf2Config from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "zones": [ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOf2ConfigZonesInner.from_dict(_item) for _item in obj["zones"]] if obj.get("zones") is not None else None
        })
        return _obj


