# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_load_balancer_monitors200_response_all_of_load_balancer_monitors_inner_load_balancer import ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer
from typing import Optional, Set
from typing_extensions import Self

class ListLoadBalancerPools200ResponseAllOfLoadBalancerPoolsInner(BaseModel):
    """
    ListLoadBalancerPools200ResponseAllOfLoadBalancerPoolsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    load_balancer: Optional[ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer] = Field(default=None, alias="loadBalancer")
    name: Optional[StrictStr] = None
    category: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    enabled: Optional[StrictBool] = None
    vip_sticky: Optional[StrictStr] = Field(default=None, alias="vipSticky")
    vip_balance: Optional[StrictStr] = Field(default=None, alias="vipBalance")
    allow_nat: Optional[StrictStr] = Field(default=None, alias="allowNat")
    allow_snat: Optional[StrictStr] = Field(default=None, alias="allowSnat")
    vip_client_ip_mode: Optional[StrictStr] = Field(default=None, alias="vipClientIpMode")
    vip_server_ip_mode: Optional[StrictStr] = Field(default=None, alias="vipServerIpMode")
    min_active: Optional[StrictInt] = Field(default=None, alias="minActive")
    min_in_service: Optional[StrictStr] = Field(default=None, alias="minInService")
    min_up_monitor: Optional[StrictStr] = Field(default=None, alias="minUpMonitor")
    min_up_action: Optional[StrictStr] = Field(default=None, alias="minUpAction")
    max_queue_depth: Optional[StrictStr] = Field(default=None, alias="maxQueueDepth")
    max_queue_time: Optional[StrictStr] = Field(default=None, alias="maxQueueTime")
    number_active: Optional[StrictInt] = Field(default=None, alias="numberActive")
    number_in_service: Optional[StrictInt] = Field(default=None, alias="numberInService")
    health_score: Optional[StrictInt] = Field(default=None, alias="healthScore")
    performance_score: Optional[StrictInt] = Field(default=None, alias="performanceScore")
    health_penalty: Optional[StrictInt] = Field(default=None, alias="healthPenalty")
    security_penalty: Optional[StrictInt] = Field(default=None, alias="securityPenalty")
    error_penalty: Optional[StrictInt] = Field(default=None, alias="errorPenalty")
    down_action: Optional[StrictStr] = Field(default=None, alias="downAction")
    ramp_time: Optional[StrictStr] = Field(default=None, alias="rampTime")
    port: Optional[StrictStr] = None
    port_type: Optional[StrictStr] = Field(default=None, alias="portType")
    status: Optional[StrictStr] = None
    nodes: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    monitors: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    members: Optional[List[Dict[str, Any]]] = None
    config: Optional[Dict[str, Any]] = None
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "loadBalancer", "name", "category", "visibility", "description", "internalId", "externalId", "enabled", "vipSticky", "vipBalance", "allowNat", "allowSnat", "vipClientIpMode", "vipServerIpMode", "minActive", "minInService", "minUpMonitor", "minUpAction", "maxQueueDepth", "maxQueueTime", "numberActive", "numberInService", "healthScore", "performanceScore", "healthPenalty", "securityPenalty", "errorPenalty", "downAction", "rampTime", "port", "portType", "status", "nodes", "monitors", "members", "config", "createdBy", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListLoadBalancerPools200ResponseAllOfLoadBalancerPoolsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of load_balancer
        if self.load_balancer:
            _dict['loadBalancer'] = self.load_balancer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in nodes (list)
        _items = []
        if self.nodes:
            for _item_nodes in self.nodes:
                if _item_nodes:
                    _items.append(_item_nodes.to_dict())
            _dict['nodes'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in monitors (list)
        _items = []
        if self.monitors:
            for _item_monitors in self.monitors:
                if _item_monitors:
                    _items.append(_item_monitors.to_dict())
            _dict['monitors'] = _items
        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if vip_sticky (nullable) is None
        # and model_fields_set contains the field
        if self.vip_sticky is None and "vip_sticky" in self.model_fields_set:
            _dict['vipSticky'] = None

        # set to None if allow_nat (nullable) is None
        # and model_fields_set contains the field
        if self.allow_nat is None and "allow_nat" in self.model_fields_set:
            _dict['allowNat'] = None

        # set to None if allow_snat (nullable) is None
        # and model_fields_set contains the field
        if self.allow_snat is None and "allow_snat" in self.model_fields_set:
            _dict['allowSnat'] = None

        # set to None if vip_client_ip_mode (nullable) is None
        # and model_fields_set contains the field
        if self.vip_client_ip_mode is None and "vip_client_ip_mode" in self.model_fields_set:
            _dict['vipClientIpMode'] = None

        # set to None if vip_server_ip_mode (nullable) is None
        # and model_fields_set contains the field
        if self.vip_server_ip_mode is None and "vip_server_ip_mode" in self.model_fields_set:
            _dict['vipServerIpMode'] = None

        # set to None if min_in_service (nullable) is None
        # and model_fields_set contains the field
        if self.min_in_service is None and "min_in_service" in self.model_fields_set:
            _dict['minInService'] = None

        # set to None if min_up_monitor (nullable) is None
        # and model_fields_set contains the field
        if self.min_up_monitor is None and "min_up_monitor" in self.model_fields_set:
            _dict['minUpMonitor'] = None

        # set to None if min_up_action (nullable) is None
        # and model_fields_set contains the field
        if self.min_up_action is None and "min_up_action" in self.model_fields_set:
            _dict['minUpAction'] = None

        # set to None if max_queue_depth (nullable) is None
        # and model_fields_set contains the field
        if self.max_queue_depth is None and "max_queue_depth" in self.model_fields_set:
            _dict['maxQueueDepth'] = None

        # set to None if max_queue_time (nullable) is None
        # and model_fields_set contains the field
        if self.max_queue_time is None and "max_queue_time" in self.model_fields_set:
            _dict['maxQueueTime'] = None

        # set to None if down_action (nullable) is None
        # and model_fields_set contains the field
        if self.down_action is None and "down_action" in self.model_fields_set:
            _dict['downAction'] = None

        # set to None if ramp_time (nullable) is None
        # and model_fields_set contains the field
        if self.ramp_time is None and "ramp_time" in self.model_fields_set:
            _dict['rampTime'] = None

        # set to None if port (nullable) is None
        # and model_fields_set contains the field
        if self.port is None and "port" in self.model_fields_set:
            _dict['port'] = None

        # set to None if port_type (nullable) is None
        # and model_fields_set contains the field
        if self.port_type is None and "port_type" in self.model_fields_set:
            _dict['portType'] = None

        # set to None if created_by (nullable) is None
        # and model_fields_set contains the field
        if self.created_by is None and "created_by" in self.model_fields_set:
            _dict['createdBy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListLoadBalancerPools200ResponseAllOfLoadBalancerPoolsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "loadBalancer": ListLoadBalancerMonitors200ResponseAllOfLoadBalancerMonitorsInnerLoadBalancer.from_dict(obj["loadBalancer"]) if obj.get("loadBalancer") is not None else None,
            "name": obj.get("name"),
            "category": obj.get("category"),
            "visibility": obj.get("visibility"),
            "description": obj.get("description"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "enabled": obj.get("enabled"),
            "vipSticky": obj.get("vipSticky"),
            "vipBalance": obj.get("vipBalance"),
            "allowNat": obj.get("allowNat"),
            "allowSnat": obj.get("allowSnat"),
            "vipClientIpMode": obj.get("vipClientIpMode"),
            "vipServerIpMode": obj.get("vipServerIpMode"),
            "minActive": obj.get("minActive"),
            "minInService": obj.get("minInService"),
            "minUpMonitor": obj.get("minUpMonitor"),
            "minUpAction": obj.get("minUpAction"),
            "maxQueueDepth": obj.get("maxQueueDepth"),
            "maxQueueTime": obj.get("maxQueueTime"),
            "numberActive": obj.get("numberActive"),
            "numberInService": obj.get("numberInService"),
            "healthScore": obj.get("healthScore"),
            "performanceScore": obj.get("performanceScore"),
            "healthPenalty": obj.get("healthPenalty"),
            "securityPenalty": obj.get("securityPenalty"),
            "errorPenalty": obj.get("errorPenalty"),
            "downAction": obj.get("downAction"),
            "rampTime": obj.get("rampTime"),
            "port": obj.get("port"),
            "portType": obj.get("portType"),
            "status": obj.get("status"),
            "nodes": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["nodes"]] if obj.get("nodes") is not None else None,
            "monitors": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["monitors"]] if obj.get("monitors") is not None else None,
            "members": obj.get("members"),
            "config": obj.get("config"),
            "createdBy": obj.get("createdBy"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


