# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_integrations200_response_any_of_integrations_inner_any_of_credential import ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential
from morpheus.models.list_network_servers200_response_all_of_network_servers_inner_account import ListNetworkServers200ResponseAllOfNetworkServersInnerAccount
from morpheus.models.list_network_servers200_response_all_of_network_servers_inner_integration import ListNetworkServers200ResponseAllOfNetworkServersInnerIntegration
from morpheus.models.list_network_servers200_response_all_of_network_servers_inner_type import ListNetworkServers200ResponseAllOfNetworkServersInnerType
from typing import Optional, Set
from typing_extensions import Self

class ListNetworkServers200ResponseAllOfNetworkServersInner(BaseModel):
    """
    ListNetworkServers200ResponseAllOfNetworkServersInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="Network Server ID")
    name: Optional[StrictStr] = Field(default=None, description="Name")
    description: Optional[StrictStr] = Field(default=None, description="Description")
    type: Optional[ListNetworkServers200ResponseAllOfNetworkServersInnerType] = None
    integration: Optional[ListNetworkServers200ResponseAllOfNetworkServersInnerIntegration] = None
    account: Optional[ListNetworkServers200ResponseAllOfNetworkServersInnerAccount] = None
    visibility: Optional[StrictStr] = None
    internal_id: Optional[StrictStr] = Field(default=None, description="Internal ID", alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, description="External ID", alias="externalId")
    service_url: Optional[StrictStr] = Field(default=None, description="Service URL", alias="serviceUrl")
    service_host: Optional[StrictStr] = Field(default=None, description="Service Host", alias="serviceHost")
    service_port: Optional[StrictInt] = Field(default=None, description="Service Port", alias="servicePort")
    service_mode: Optional[StrictStr] = Field(default=None, description="Service Mode", alias="serviceMode")
    service_path: Optional[StrictStr] = Field(default=None, description="Service Path", alias="servicePath")
    service_username: Optional[StrictStr] = Field(default=None, description="Service Username", alias="serviceUsername")
    service_password: Optional[StrictStr] = Field(default=None, description="Service Password", alias="servicePassword")
    service_password_hash: Optional[StrictStr] = Field(default=None, alias="servicePasswordHash")
    service_token: Optional[StrictStr] = Field(default=None, description="Service Token", alias="serviceToken")
    service_token_hash: Optional[StrictStr] = Field(default=None, alias="serviceTokenHash")
    api_port: Optional[StrictInt] = Field(default=None, alias="apiPort")
    admin_port: Optional[StrictInt] = Field(default=None, alias="adminPort")
    status: Optional[StrictStr] = Field(default=None, description="Status")
    status_message: Optional[StrictStr] = Field(default=None, description="Status Message", alias="statusMessage")
    status_date: Optional[datetime] = Field(default=None, alias="statusDate")
    last_sync: Optional[datetime] = Field(default=None, description="Last Sync Date", alias="lastSync")
    next_run_date: Optional[datetime] = Field(default=None, description="Next Run Date", alias="nextRunDate")
    last_sync_duration: Optional[StrictInt] = Field(default=None, description="Last Sync Duration in milliseconds", alias="lastSyncDuration")
    config: Optional[Dict[str, Any]] = Field(default=None, description="Config object varies with network server type.")
    network_filter: Optional[StrictStr] = Field(default=None, description="Network Filter", alias="networkFilter")
    tenant_match: Optional[StrictStr] = Field(default=None, description="Tenant Match", alias="tenantMatch")
    zone_id: Optional[StrictInt] = Field(default=None, description="Cloud ID", alias="zoneId")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    enabled: Optional[StrictBool] = None
    visible: Optional[StrictBool] = None
    credential: Optional[ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential] = None
    tenants: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "type", "integration", "account", "visibility", "internalId", "externalId", "serviceUrl", "serviceHost", "servicePort", "serviceMode", "servicePath", "serviceUsername", "servicePassword", "servicePasswordHash", "serviceToken", "serviceTokenHash", "apiPort", "adminPort", "status", "statusMessage", "statusDate", "lastSync", "nextRunDate", "lastSyncDuration", "config", "networkFilter", "tenantMatch", "zoneId", "dateCreated", "lastUpdated", "enabled", "visible", "credential", "tenants"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListNetworkServers200ResponseAllOfNetworkServersInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of integration
        if self.integration:
            _dict['integration'] = self.integration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if service_url (nullable) is None
        # and model_fields_set contains the field
        if self.service_url is None and "service_url" in self.model_fields_set:
            _dict['serviceUrl'] = None

        # set to None if service_host (nullable) is None
        # and model_fields_set contains the field
        if self.service_host is None and "service_host" in self.model_fields_set:
            _dict['serviceHost'] = None

        # set to None if service_port (nullable) is None
        # and model_fields_set contains the field
        if self.service_port is None and "service_port" in self.model_fields_set:
            _dict['servicePort'] = None

        # set to None if service_mode (nullable) is None
        # and model_fields_set contains the field
        if self.service_mode is None and "service_mode" in self.model_fields_set:
            _dict['serviceMode'] = None

        # set to None if service_path (nullable) is None
        # and model_fields_set contains the field
        if self.service_path is None and "service_path" in self.model_fields_set:
            _dict['servicePath'] = None

        # set to None if service_username (nullable) is None
        # and model_fields_set contains the field
        if self.service_username is None and "service_username" in self.model_fields_set:
            _dict['serviceUsername'] = None

        # set to None if service_password (nullable) is None
        # and model_fields_set contains the field
        if self.service_password is None and "service_password" in self.model_fields_set:
            _dict['servicePassword'] = None

        # set to None if service_password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.service_password_hash is None and "service_password_hash" in self.model_fields_set:
            _dict['servicePasswordHash'] = None

        # set to None if service_token (nullable) is None
        # and model_fields_set contains the field
        if self.service_token is None and "service_token" in self.model_fields_set:
            _dict['serviceToken'] = None

        # set to None if service_token_hash (nullable) is None
        # and model_fields_set contains the field
        if self.service_token_hash is None and "service_token_hash" in self.model_fields_set:
            _dict['serviceTokenHash'] = None

        # set to None if api_port (nullable) is None
        # and model_fields_set contains the field
        if self.api_port is None and "api_port" in self.model_fields_set:
            _dict['apiPort'] = None

        # set to None if admin_port (nullable) is None
        # and model_fields_set contains the field
        if self.admin_port is None and "admin_port" in self.model_fields_set:
            _dict['adminPort'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if status_date (nullable) is None
        # and model_fields_set contains the field
        if self.status_date is None and "status_date" in self.model_fields_set:
            _dict['statusDate'] = None

        # set to None if last_sync (nullable) is None
        # and model_fields_set contains the field
        if self.last_sync is None and "last_sync" in self.model_fields_set:
            _dict['lastSync'] = None

        # set to None if next_run_date (nullable) is None
        # and model_fields_set contains the field
        if self.next_run_date is None and "next_run_date" in self.model_fields_set:
            _dict['nextRunDate'] = None

        # set to None if last_sync_duration (nullable) is None
        # and model_fields_set contains the field
        if self.last_sync_duration is None and "last_sync_duration" in self.model_fields_set:
            _dict['lastSyncDuration'] = None

        # set to None if network_filter (nullable) is None
        # and model_fields_set contains the field
        if self.network_filter is None and "network_filter" in self.model_fields_set:
            _dict['networkFilter'] = None

        # set to None if tenant_match (nullable) is None
        # and model_fields_set contains the field
        if self.tenant_match is None and "tenant_match" in self.model_fields_set:
            _dict['tenantMatch'] = None

        # set to None if zone_id (nullable) is None
        # and model_fields_set contains the field
        if self.zone_id is None and "zone_id" in self.model_fields_set:
            _dict['zoneId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListNetworkServers200ResponseAllOfNetworkServersInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "type": ListNetworkServers200ResponseAllOfNetworkServersInnerType.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "integration": ListNetworkServers200ResponseAllOfNetworkServersInnerIntegration.from_dict(obj["integration"]) if obj.get("integration") is not None else None,
            "account": ListNetworkServers200ResponseAllOfNetworkServersInnerAccount.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "visibility": obj.get("visibility"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "serviceUrl": obj.get("serviceUrl"),
            "serviceHost": obj.get("serviceHost"),
            "servicePort": obj.get("servicePort"),
            "serviceMode": obj.get("serviceMode"),
            "servicePath": obj.get("servicePath"),
            "serviceUsername": obj.get("serviceUsername"),
            "servicePassword": obj.get("servicePassword"),
            "servicePasswordHash": obj.get("servicePasswordHash"),
            "serviceToken": obj.get("serviceToken"),
            "serviceTokenHash": obj.get("serviceTokenHash"),
            "apiPort": obj.get("apiPort"),
            "adminPort": obj.get("adminPort"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "statusDate": obj.get("statusDate"),
            "lastSync": obj.get("lastSync"),
            "nextRunDate": obj.get("nextRunDate"),
            "lastSyncDuration": obj.get("lastSyncDuration"),
            "config": obj.get("config"),
            "networkFilter": obj.get("networkFilter"),
            "tenantMatch": obj.get("tenantMatch"),
            "zoneId": obj.get("zoneId"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated"),
            "enabled": obj.get("enabled"),
            "visible": obj.get("visible"),
            "credential": ListIntegrations200ResponseAnyOfIntegrationsInnerAnyOfCredential.from_dict(obj["credential"]) if obj.get("credential") is not None else None,
            "tenants": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None
        })
        return _obj


