# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_clouds200_response_all_of_zones_inner_credential_any_of import ListClouds200ResponseAllOfZonesInnerCredentialAnyOf
from morpheus.models.list_option_lists200_response_all_of_option_types_inner_config import ListOptionLists200ResponseAllOfOptionTypesInnerConfig
from typing import Optional, Set
from typing_extensions import Self

class ListOptionLists200ResponseAllOfOptionTypesInner(BaseModel):
    """
    ListOptionLists200ResponseAllOfOptionTypesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    type: Optional[StrictStr] = None
    source_url: Optional[StrictStr] = Field(default=None, alias="sourceUrl")
    source_method: Optional[StrictStr] = Field(default=None, alias="sourceMethod")
    api_type: Optional[StrictStr] = Field(default=None, alias="apiType")
    ignore_ssl_errors: Optional[StrictBool] = Field(default=None, alias="ignoreSSLErrors")
    real_time: Optional[StrictBool] = Field(default=None, alias="realTime")
    visibility: Optional[StrictStr] = None
    config: Optional[ListOptionLists200ResponseAllOfOptionTypesInnerConfig] = None
    credential: Optional[ListClouds200ResponseAllOfZonesInnerCredentialAnyOf] = None
    service_username: Optional[StrictStr] = Field(default=None, alias="serviceUsername")
    service_password: Optional[StrictStr] = Field(default=None, alias="servicePassword")
    initial_dataset: Optional[StrictStr] = Field(default=None, alias="initialDataset")
    translation_script: Optional[StrictStr] = Field(default=None, alias="translationScript")
    request_script: Optional[StrictStr] = Field(default=None, alias="requestScript")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "labels", "type", "sourceUrl", "sourceMethod", "apiType", "ignoreSSLErrors", "realTime", "visibility", "config", "credential", "serviceUsername", "servicePassword", "initialDataset", "translationScript", "requestScript", "account"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListOptionLists200ResponseAllOfOptionTypesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if api_type (nullable) is None
        # and model_fields_set contains the field
        if self.api_type is None and "api_type" in self.model_fields_set:
            _dict['apiType'] = None

        # set to None if service_username (nullable) is None
        # and model_fields_set contains the field
        if self.service_username is None and "service_username" in self.model_fields_set:
            _dict['serviceUsername'] = None

        # set to None if service_password (nullable) is None
        # and model_fields_set contains the field
        if self.service_password is None and "service_password" in self.model_fields_set:
            _dict['servicePassword'] = None

        # set to None if initial_dataset (nullable) is None
        # and model_fields_set contains the field
        if self.initial_dataset is None and "initial_dataset" in self.model_fields_set:
            _dict['initialDataset'] = None

        # set to None if request_script (nullable) is None
        # and model_fields_set contains the field
        if self.request_script is None and "request_script" in self.model_fields_set:
            _dict['requestScript'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListOptionLists200ResponseAllOfOptionTypesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "labels": obj.get("labels"),
            "type": obj.get("type"),
            "sourceUrl": obj.get("sourceUrl"),
            "sourceMethod": obj.get("sourceMethod"),
            "apiType": obj.get("apiType"),
            "ignoreSSLErrors": obj.get("ignoreSSLErrors"),
            "realTime": obj.get("realTime"),
            "visibility": obj.get("visibility"),
            "config": ListOptionLists200ResponseAllOfOptionTypesInnerConfig.from_dict(obj["config"]) if obj.get("config") is not None else None,
            "credential": ListClouds200ResponseAllOfZonesInnerCredentialAnyOf.from_dict(obj["credential"]) if obj.get("credential") is not None else None,
            "serviceUsername": obj.get("serviceUsername"),
            "servicePassword": obj.get("servicePassword"),
            "initialDataset": obj.get("initialDataset"),
            "translationScript": obj.get("translationScript"),
            "requestScript": obj.get("requestScript"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None
        })
        return _obj


