# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_os_types200_response_all_of_os_types_inner_images_inner import ListOsTypes200ResponseAllOfOsTypesInnerImagesInner
from typing import Optional, Set
from typing_extensions import Self

class ListOsTypes200ResponseAllOfOsTypesInner(BaseModel):
    """
    ListOsTypes200ResponseAllOfOsTypesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = Field(default=None, description="The name of the osType. ")
    description: Optional[StrictStr] = Field(default=None, description="The description of the osType.  ")
    platform: Optional[StrictStr] = Field(default=None, description="The platform of the osType.  ")
    category: Optional[StrictStr] = Field(default=None, description="The category of the osType. ")
    vendor: Optional[StrictStr] = Field(default=None, description="The vendor of the osType. ")
    os_name: Optional[StrictStr] = Field(default=None, description="The osName of the osType. ", alias="osName")
    os_version: Optional[StrictStr] = Field(default=None, description="The osVersion of the osType. ", alias="osVersion")
    os_codename: Optional[StrictStr] = Field(default=None, description="The osCodename of the osType. ", alias="osCodename")
    os_family: Optional[StrictStr] = Field(default=None, description="The family of the osType. ", alias="osFamily")
    bit_count: Optional[StrictInt] = Field(default=None, description="The bitCount/architecture of the osType. ", alias="bitCount")
    cloud_init_version: Optional[StrictStr] = Field(default=None, description="The version of CloudInit being used. ", alias="cloudInitVersion")
    install_agent: Optional[StrictBool] = Field(default=None, description="Whether the morpheus agent is installed. ", alias="installAgent")
    images: Optional[List[ListOsTypes200ResponseAllOfOsTypesInnerImagesInner]] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "platform", "category", "vendor", "osName", "osVersion", "osCodename", "osFamily", "bitCount", "cloudInitVersion", "installAgent", "images"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListOsTypes200ResponseAllOfOsTypesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in images (list)
        _items = []
        if self.images:
            for _item_images in self.images:
                if _item_images:
                    _items.append(_item_images.to_dict())
            _dict['images'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if vendor (nullable) is None
        # and model_fields_set contains the field
        if self.vendor is None and "vendor" in self.model_fields_set:
            _dict['vendor'] = None

        # set to None if os_name (nullable) is None
        # and model_fields_set contains the field
        if self.os_name is None and "os_name" in self.model_fields_set:
            _dict['osName'] = None

        # set to None if os_version (nullable) is None
        # and model_fields_set contains the field
        if self.os_version is None and "os_version" in self.model_fields_set:
            _dict['osVersion'] = None

        # set to None if os_codename (nullable) is None
        # and model_fields_set contains the field
        if self.os_codename is None and "os_codename" in self.model_fields_set:
            _dict['osCodename'] = None

        # set to None if os_family (nullable) is None
        # and model_fields_set contains the field
        if self.os_family is None and "os_family" in self.model_fields_set:
            _dict['osFamily'] = None

        # set to None if install_agent (nullable) is None
        # and model_fields_set contains the field
        if self.install_agent is None and "install_agent" in self.model_fields_set:
            _dict['installAgent'] = None

        # set to None if images (nullable) is None
        # and model_fields_set contains the field
        if self.images is None and "images" in self.model_fields_set:
            _dict['images'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListOsTypes200ResponseAllOfOsTypesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "platform": obj.get("platform"),
            "category": obj.get("category"),
            "vendor": obj.get("vendor"),
            "osName": obj.get("osName"),
            "osVersion": obj.get("osVersion"),
            "osCodename": obj.get("osCodename"),
            "osFamily": obj.get("osFamily"),
            "bitCount": obj.get("bitCount"),
            "cloudInitVersion": obj.get("cloudInitVersion"),
            "installAgent": obj.get("installAgent"),
            "images": [ListOsTypes200ResponseAllOfOsTypesInnerImagesInner.from_dict(_item) for _item in obj["images"]] if obj.get("images") is not None else None
        })
        return _obj


