# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_app_state200_response_all_of_specs_inner_template import GetAppState200ResponseAllOfSpecsInnerTemplate
from morpheus.models.list_catalog_item_types200_response_all_of_catalog_item_types_inner_option_types_inner import ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner
from typing import Optional, Set
from typing_extensions import Self

class ListPlugins200ResponseAllOfPluginsInner(BaseModel):
    """
    ListPlugins200ResponseAllOfPluginsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    version: Optional[StrictStr] = None
    enabled: Optional[StrictBool] = None
    author: Optional[StrictStr] = None
    website_url: Optional[StrictStr] = Field(default=None, alias="websiteUrl")
    source_code_location_url: Optional[StrictStr] = Field(default=None, alias="sourceCodeLocationUrl")
    issue_tracker_url: Optional[StrictStr] = Field(default=None, alias="issueTrackerUrl")
    valid: Optional[StrictBool] = None
    has_valid_update: Optional[StrictBool] = Field(default=None, alias="hasValidUpdate")
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    providers: Optional[List[GetAppState200ResponseAllOfSpecsInnerTemplate]] = None
    config: Optional[Dict[str, Any]] = None
    option_types: Optional[List[ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner]] = Field(default=None, alias="optionTypes")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "name", "code", "description", "version", "enabled", "author", "websiteUrl", "sourceCodeLocationUrl", "issueTrackerUrl", "valid", "hasValidUpdate", "status", "statusMessage", "providers", "config", "optionTypes", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListPlugins200ResponseAllOfPluginsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in providers (list)
        _items = []
        if self.providers:
            for _item_providers in self.providers:
                if _item_providers:
                    _items.append(_item_providers.to_dict())
            _dict['providers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in option_types (list)
        _items = []
        if self.option_types:
            for _item_option_types in self.option_types:
                if _item_option_types:
                    _items.append(_item_option_types.to_dict())
            _dict['optionTypes'] = _items
        # set to None if author (nullable) is None
        # and model_fields_set contains the field
        if self.author is None and "author" in self.model_fields_set:
            _dict['author'] = None

        # set to None if website_url (nullable) is None
        # and model_fields_set contains the field
        if self.website_url is None and "website_url" in self.model_fields_set:
            _dict['websiteUrl'] = None

        # set to None if source_code_location_url (nullable) is None
        # and model_fields_set contains the field
        if self.source_code_location_url is None and "source_code_location_url" in self.model_fields_set:
            _dict['sourceCodeLocationUrl'] = None

        # set to None if issue_tracker_url (nullable) is None
        # and model_fields_set contains the field
        if self.issue_tracker_url is None and "issue_tracker_url" in self.model_fields_set:
            _dict['issueTrackerUrl'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListPlugins200ResponseAllOfPluginsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "description": obj.get("description"),
            "version": obj.get("version"),
            "enabled": obj.get("enabled"),
            "author": obj.get("author"),
            "websiteUrl": obj.get("websiteUrl"),
            "sourceCodeLocationUrl": obj.get("sourceCodeLocationUrl"),
            "issueTrackerUrl": obj.get("issueTrackerUrl"),
            "valid": obj.get("valid"),
            "hasValidUpdate": obj.get("hasValidUpdate"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "providers": [GetAppState200ResponseAllOfSpecsInnerTemplate.from_dict(_item) for _item in obj["providers"]] if obj.get("providers") is not None else None,
            "config": obj.get("config"),
            "optionTypes": [ListCatalogItemTypes200ResponseAllOfCatalogItemTypesInnerOptionTypesInner.from_dict(_item) for _item in obj["optionTypes"]] if obj.get("optionTypes") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


