# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListScripts200ResponseAllOfContainerScriptsInner(BaseModel):
    """
    ListScripts200ResponseAllOfContainerScriptsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    code: Optional[StrictStr] = None
    account: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    category: Optional[StrictStr] = None
    sort_order: Optional[StrictInt] = Field(default=None, alias="sortOrder")
    script_version: Optional[StrictStr] = Field(default=None, alias="scriptVersion")
    script_phase: Optional[StrictStr] = Field(default=None, alias="scriptPhase")
    script_type: Optional[StrictStr] = Field(default=None, alias="scriptType")
    script: Optional[StrictStr] = None
    script_service: Optional[StrictStr] = Field(default=None, alias="scriptService")
    script_method: Optional[StrictStr] = Field(default=None, alias="scriptMethod")
    run_as_user: Optional[StrictStr] = Field(default=None, alias="runAsUser")
    run_as_password: Optional[StrictStr] = Field(default=None, alias="runAsPassword")
    sudo_user: Optional[StrictBool] = Field(default=None, alias="sudoUser")
    fail_on_error: Optional[StrictBool] = Field(default=None, alias="failOnError")
    __properties: ClassVar[List[str]] = ["id", "code", "account", "name", "labels", "category", "sortOrder", "scriptVersion", "scriptPhase", "scriptType", "script", "scriptService", "scriptMethod", "runAsUser", "runAsPassword", "sudoUser", "failOnError"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListScripts200ResponseAllOfContainerScriptsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if account (nullable) is None
        # and model_fields_set contains the field
        if self.account is None and "account" in self.model_fields_set:
            _dict['account'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if category (nullable) is None
        # and model_fields_set contains the field
        if self.category is None and "category" in self.model_fields_set:
            _dict['category'] = None

        # set to None if script_service (nullable) is None
        # and model_fields_set contains the field
        if self.script_service is None and "script_service" in self.model_fields_set:
            _dict['scriptService'] = None

        # set to None if script_method (nullable) is None
        # and model_fields_set contains the field
        if self.script_method is None and "script_method" in self.model_fields_set:
            _dict['scriptMethod'] = None

        # set to None if run_as_user (nullable) is None
        # and model_fields_set contains the field
        if self.run_as_user is None and "run_as_user" in self.model_fields_set:
            _dict['runAsUser'] = None

        # set to None if run_as_password (nullable) is None
        # and model_fields_set contains the field
        if self.run_as_password is None and "run_as_password" in self.model_fields_set:
            _dict['runAsPassword'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListScripts200ResponseAllOfContainerScriptsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "account": obj.get("account"),
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "category": obj.get("category"),
            "sortOrder": obj.get("sortOrder"),
            "scriptVersion": obj.get("scriptVersion"),
            "scriptPhase": obj.get("scriptPhase"),
            "scriptType": obj.get("scriptType"),
            "script": obj.get("script"),
            "scriptService": obj.get("scriptService"),
            "scriptMethod": obj.get("scriptMethod"),
            "runAsUser": obj.get("runAsUser"),
            "runAsPassword": obj.get("runAsPassword"),
            "sudoUser": obj.get("sudoUser"),
            "failOnError": obj.get("failOnError")
        })
        return _obj


