# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_cluster_datastores200_response_all_of_datastores_inner_resource_permissions import ListClusterDatastores200ResponseAllOfDatastoresInnerResourcePermissions
from morpheus.models.list_security_groups200_response_all_of_security_groups_inner_locations_inner import ListSecurityGroups200ResponseAllOfSecurityGroupsInnerLocationsInner
from morpheus.models.list_security_groups200_response_all_of_security_groups_inner_rules_inner import ListSecurityGroups200ResponseAllOfSecurityGroupsInnerRulesInner
from morpheus.models.list_security_groups200_response_all_of_security_groups_inner_tenants_inner import ListSecurityGroups200ResponseAllOfSecurityGroupsInnerTenantsInner
from typing import Optional, Set
from typing_extensions import Self

class ListSecurityGroups200ResponseAllOfSecurityGroupsInner(BaseModel):
    """
    ListSecurityGroups200ResponseAllOfSecurityGroupsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    group_source: Optional[StrictStr] = Field(default=None, alias="groupSource")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    enabled: Optional[StrictStr] = None
    sync_source: Optional[StrictStr] = Field(default=None, alias="syncSource")
    visibility: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    zone: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    locations: Optional[List[ListSecurityGroups200ResponseAllOfSecurityGroupsInnerLocationsInner]] = None
    rules: Optional[List[ListSecurityGroups200ResponseAllOfSecurityGroupsInnerRulesInner]] = None
    tenants: Optional[List[ListSecurityGroups200ResponseAllOfSecurityGroupsInnerTenantsInner]] = None
    resource_permission: Optional[ListClusterDatastores200ResponseAllOfDatastoresInnerResourcePermissions] = Field(default=None, alias="resourcePermission")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "accountId", "groupSource", "externalId", "enabled", "syncSource", "visibility", "active", "zone", "locations", "rules", "tenants", "resourcePermission"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListSecurityGroups200ResponseAllOfSecurityGroupsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in locations (list)
        _items = []
        if self.locations:
            for _item_locations in self.locations:
                if _item_locations:
                    _items.append(_item_locations.to_dict())
            _dict['locations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in rules (list)
        _items = []
        if self.rules:
            for _item_rules in self.rules:
                if _item_rules:
                    _items.append(_item_rules.to_dict())
            _dict['rules'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_permission
        if self.resource_permission:
            _dict['resourcePermission'] = self.resource_permission.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if group_source (nullable) is None
        # and model_fields_set contains the field
        if self.group_source is None and "group_source" in self.model_fields_set:
            _dict['groupSource'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if enabled (nullable) is None
        # and model_fields_set contains the field
        if self.enabled is None and "enabled" in self.model_fields_set:
            _dict['enabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListSecurityGroups200ResponseAllOfSecurityGroupsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "accountId": obj.get("accountId"),
            "groupSource": obj.get("groupSource"),
            "externalId": obj.get("externalId"),
            "enabled": obj.get("enabled"),
            "syncSource": obj.get("syncSource"),
            "visibility": obj.get("visibility"),
            "active": obj.get("active"),
            "zone": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "locations": [ListSecurityGroups200ResponseAllOfSecurityGroupsInnerLocationsInner.from_dict(_item) for _item in obj["locations"]] if obj.get("locations") is not None else None,
            "rules": [ListSecurityGroups200ResponseAllOfSecurityGroupsInnerRulesInner.from_dict(_item) for _item in obj["rules"]] if obj.get("rules") is not None else None,
            "tenants": [ListSecurityGroups200ResponseAllOfSecurityGroupsInnerTenantsInner.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None,
            "resourcePermission": ListClusterDatastores200ResponseAllOfDatastoresInnerResourcePermissions.from_dict(obj["resourcePermission"]) if obj.get("resourcePermission") is not None else None
        })
        return _obj


