# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class ListServicePlans200ResponseAllOfServicePlansInnerConfigRanges(BaseModel):
    """
    ListServicePlans200ResponseAllOfServicePlansInnerConfigRanges
    """ # noqa: E501
    min_storage: Optional[StrictStr] = Field(default=None, alias="minStorage")
    max_storage: Optional[StrictStr] = Field(default=None, alias="maxStorage")
    min_per_disk_size: Optional[StrictStr] = Field(default=None, alias="minPerDiskSize")
    max_per_disk_size: Optional[StrictStr] = Field(default=None, alias="maxPerDiskSize")
    min_memory: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="minMemory")
    max_memory: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="maxMemory")
    min_cores: Optional[StrictStr] = Field(default=None, alias="minCores")
    max_cores: Optional[StrictStr] = Field(default=None, alias="maxCores")
    min_sockets: Optional[StrictStr] = Field(default=None, alias="minSockets")
    max_sockets: Optional[StrictStr] = Field(default=None, alias="maxSockets")
    min_cores_per_socket: Optional[StrictStr] = Field(default=None, alias="minCoresPerSocket")
    max_cores_per_socket: Optional[StrictStr] = Field(default=None, alias="maxCoresPerSocket")
    __properties: ClassVar[List[str]] = ["minStorage", "maxStorage", "minPerDiskSize", "maxPerDiskSize", "minMemory", "maxMemory", "minCores", "maxCores", "minSockets", "maxSockets", "minCoresPerSocket", "maxCoresPerSocket"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListServicePlans200ResponseAllOfServicePlansInnerConfigRanges from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if min_storage (nullable) is None
        # and model_fields_set contains the field
        if self.min_storage is None and "min_storage" in self.model_fields_set:
            _dict['minStorage'] = None

        # set to None if max_storage (nullable) is None
        # and model_fields_set contains the field
        if self.max_storage is None and "max_storage" in self.model_fields_set:
            _dict['maxStorage'] = None

        # set to None if min_per_disk_size (nullable) is None
        # and model_fields_set contains the field
        if self.min_per_disk_size is None and "min_per_disk_size" in self.model_fields_set:
            _dict['minPerDiskSize'] = None

        # set to None if max_per_disk_size (nullable) is None
        # and model_fields_set contains the field
        if self.max_per_disk_size is None and "max_per_disk_size" in self.model_fields_set:
            _dict['maxPerDiskSize'] = None

        # set to None if min_memory (nullable) is None
        # and model_fields_set contains the field
        if self.min_memory is None and "min_memory" in self.model_fields_set:
            _dict['minMemory'] = None

        # set to None if max_memory (nullable) is None
        # and model_fields_set contains the field
        if self.max_memory is None and "max_memory" in self.model_fields_set:
            _dict['maxMemory'] = None

        # set to None if min_cores (nullable) is None
        # and model_fields_set contains the field
        if self.min_cores is None and "min_cores" in self.model_fields_set:
            _dict['minCores'] = None

        # set to None if max_cores (nullable) is None
        # and model_fields_set contains the field
        if self.max_cores is None and "max_cores" in self.model_fields_set:
            _dict['maxCores'] = None

        # set to None if min_sockets (nullable) is None
        # and model_fields_set contains the field
        if self.min_sockets is None and "min_sockets" in self.model_fields_set:
            _dict['minSockets'] = None

        # set to None if max_sockets (nullable) is None
        # and model_fields_set contains the field
        if self.max_sockets is None and "max_sockets" in self.model_fields_set:
            _dict['maxSockets'] = None

        # set to None if min_cores_per_socket (nullable) is None
        # and model_fields_set contains the field
        if self.min_cores_per_socket is None and "min_cores_per_socket" in self.model_fields_set:
            _dict['minCoresPerSocket'] = None

        # set to None if max_cores_per_socket (nullable) is None
        # and model_fields_set contains the field
        if self.max_cores_per_socket is None and "max_cores_per_socket" in self.model_fields_set:
            _dict['maxCoresPerSocket'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListServicePlans200ResponseAllOfServicePlansInnerConfigRanges from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "minStorage": obj.get("minStorage"),
            "maxStorage": obj.get("maxStorage"),
            "minPerDiskSize": obj.get("minPerDiskSize"),
            "maxPerDiskSize": obj.get("maxPerDiskSize"),
            "minMemory": obj.get("minMemory"),
            "maxMemory": obj.get("maxMemory"),
            "minCores": obj.get("minCores"),
            "maxCores": obj.get("maxCores"),
            "minSockets": obj.get("minSockets"),
            "maxSockets": obj.get("maxSockets"),
            "minCoresPerSocket": obj.get("minCoresPerSocket"),
            "maxCoresPerSocket": obj.get("maxCoresPerSocket")
        })
        return _obj


