# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListTaskTypes200ResponseTaskTypesInnerOptionTypesInner(BaseModel):
    """
    ListTaskTypes200ResponseTaskTypesInnerOptionTypesInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    field_name: Optional[StrictStr] = Field(default=None, alias="fieldName")
    field_label: Optional[StrictStr] = Field(default=None, alias="fieldLabel")
    field_code: Optional[StrictStr] = Field(default=None, alias="fieldCode")
    field_context: Optional[StrictStr] = Field(default=None, alias="fieldContext")
    field_group: Optional[StrictStr] = Field(default=None, alias="fieldGroup")
    field_class: Optional[StrictStr] = Field(default=None, alias="fieldClass")
    field_add_on: Optional[StrictStr] = Field(default=None, alias="fieldAddOn")
    field_component: Optional[StrictStr] = Field(default=None, alias="fieldComponent")
    field_input: Optional[StrictStr] = Field(default=None, alias="fieldInput")
    place_holder: Optional[StrictStr] = Field(default=None, alias="placeHolder")
    verify_pattern: Optional[StrictStr] = Field(default=None, alias="verifyPattern")
    help_block: Optional[StrictStr] = Field(default=None, alias="helpBlock")
    help_block_field_code: Optional[StrictStr] = Field(default=None, alias="helpBlockFieldCode")
    default_value: Optional[StrictStr] = Field(default=None, alias="defaultValue")
    option_source: Optional[StrictStr] = Field(default=None, alias="optionSource")
    option_source_type: Optional[StrictStr] = Field(default=None, alias="optionSourceType")
    option_list: Optional[StrictStr] = Field(default=None, alias="optionList")
    type: Optional[StrictStr] = None
    advanced: Optional[StrictBool] = None
    required: Optional[StrictBool] = None
    export_meta: Optional[StrictBool] = Field(default=None, alias="exportMeta")
    editable: Optional[StrictBool] = None
    creatable: Optional[StrictBool] = None
    config: Optional[Dict[str, Any]] = None
    display_order: Optional[StrictInt] = Field(default=None, alias="displayOrder")
    wrapper_class: Optional[StrictStr] = Field(default=None, alias="wrapperClass")
    enabled: Optional[StrictBool] = None
    no_blank: Optional[StrictBool] = Field(default=None, alias="noBlank")
    depends_on_code: Optional[StrictStr] = Field(default=None, alias="dependsOnCode")
    visible_on_code: Optional[StrictStr] = Field(default=None, alias="visibleOnCode")
    require_on_code: Optional[StrictStr] = Field(default=None, alias="requireOnCode")
    contextual_default: Optional[StrictBool] = Field(default=None, alias="contextualDefault")
    display_value_on_details: Optional[StrictBool] = Field(default=None, alias="displayValueOnDetails")
    show_on_create: Optional[StrictBool] = Field(default=None, alias="showOnCreate")
    show_on_edit: Optional[StrictBool] = Field(default=None, alias="showOnEdit")
    local_credential: Optional[StrictBool] = Field(default=None, alias="localCredential")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "code", "fieldName", "fieldLabel", "fieldCode", "fieldContext", "fieldGroup", "fieldClass", "fieldAddOn", "fieldComponent", "fieldInput", "placeHolder", "verifyPattern", "helpBlock", "helpBlockFieldCode", "defaultValue", "optionSource", "optionSourceType", "optionList", "type", "advanced", "required", "exportMeta", "editable", "creatable", "config", "displayOrder", "wrapperClass", "enabled", "noBlank", "dependsOnCode", "visibleOnCode", "requireOnCode", "contextualDefault", "displayValueOnDetails", "showOnCreate", "showOnEdit", "localCredential"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListTaskTypes200ResponseTaskTypesInnerOptionTypesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if field_group (nullable) is None
        # and model_fields_set contains the field
        if self.field_group is None and "field_group" in self.model_fields_set:
            _dict['fieldGroup'] = None

        # set to None if field_class (nullable) is None
        # and model_fields_set contains the field
        if self.field_class is None and "field_class" in self.model_fields_set:
            _dict['fieldClass'] = None

        # set to None if field_add_on (nullable) is None
        # and model_fields_set contains the field
        if self.field_add_on is None and "field_add_on" in self.model_fields_set:
            _dict['fieldAddOn'] = None

        # set to None if field_component (nullable) is None
        # and model_fields_set contains the field
        if self.field_component is None and "field_component" in self.model_fields_set:
            _dict['fieldComponent'] = None

        # set to None if field_input (nullable) is None
        # and model_fields_set contains the field
        if self.field_input is None and "field_input" in self.model_fields_set:
            _dict['fieldInput'] = None

        # set to None if place_holder (nullable) is None
        # and model_fields_set contains the field
        if self.place_holder is None and "place_holder" in self.model_fields_set:
            _dict['placeHolder'] = None

        # set to None if verify_pattern (nullable) is None
        # and model_fields_set contains the field
        if self.verify_pattern is None and "verify_pattern" in self.model_fields_set:
            _dict['verifyPattern'] = None

        # set to None if help_block (nullable) is None
        # and model_fields_set contains the field
        if self.help_block is None and "help_block" in self.model_fields_set:
            _dict['helpBlock'] = None

        # set to None if help_block_field_code (nullable) is None
        # and model_fields_set contains the field
        if self.help_block_field_code is None and "help_block_field_code" in self.model_fields_set:
            _dict['helpBlockFieldCode'] = None

        # set to None if default_value (nullable) is None
        # and model_fields_set contains the field
        if self.default_value is None and "default_value" in self.model_fields_set:
            _dict['defaultValue'] = None

        # set to None if option_source (nullable) is None
        # and model_fields_set contains the field
        if self.option_source is None and "option_source" in self.model_fields_set:
            _dict['optionSource'] = None

        # set to None if option_source_type (nullable) is None
        # and model_fields_set contains the field
        if self.option_source_type is None and "option_source_type" in self.model_fields_set:
            _dict['optionSourceType'] = None

        # set to None if option_list (nullable) is None
        # and model_fields_set contains the field
        if self.option_list is None and "option_list" in self.model_fields_set:
            _dict['optionList'] = None

        # set to None if wrapper_class (nullable) is None
        # and model_fields_set contains the field
        if self.wrapper_class is None and "wrapper_class" in self.model_fields_set:
            _dict['wrapperClass'] = None

        # set to None if depends_on_code (nullable) is None
        # and model_fields_set contains the field
        if self.depends_on_code is None and "depends_on_code" in self.model_fields_set:
            _dict['dependsOnCode'] = None

        # set to None if visible_on_code (nullable) is None
        # and model_fields_set contains the field
        if self.visible_on_code is None and "visible_on_code" in self.model_fields_set:
            _dict['visibleOnCode'] = None

        # set to None if require_on_code (nullable) is None
        # and model_fields_set contains the field
        if self.require_on_code is None and "require_on_code" in self.model_fields_set:
            _dict['requireOnCode'] = None

        # set to None if display_value_on_details (nullable) is None
        # and model_fields_set contains the field
        if self.display_value_on_details is None and "display_value_on_details" in self.model_fields_set:
            _dict['displayValueOnDetails'] = None

        # set to None if show_on_create (nullable) is None
        # and model_fields_set contains the field
        if self.show_on_create is None and "show_on_create" in self.model_fields_set:
            _dict['showOnCreate'] = None

        # set to None if show_on_edit (nullable) is None
        # and model_fields_set contains the field
        if self.show_on_edit is None and "show_on_edit" in self.model_fields_set:
            _dict['showOnEdit'] = None

        # set to None if local_credential (nullable) is None
        # and model_fields_set contains the field
        if self.local_credential is None and "local_credential" in self.model_fields_set:
            _dict['localCredential'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListTaskTypes200ResponseTaskTypesInnerOptionTypesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "code": obj.get("code"),
            "fieldName": obj.get("fieldName"),
            "fieldLabel": obj.get("fieldLabel"),
            "fieldCode": obj.get("fieldCode"),
            "fieldContext": obj.get("fieldContext"),
            "fieldGroup": obj.get("fieldGroup"),
            "fieldClass": obj.get("fieldClass"),
            "fieldAddOn": obj.get("fieldAddOn"),
            "fieldComponent": obj.get("fieldComponent"),
            "fieldInput": obj.get("fieldInput"),
            "placeHolder": obj.get("placeHolder"),
            "verifyPattern": obj.get("verifyPattern"),
            "helpBlock": obj.get("helpBlock"),
            "helpBlockFieldCode": obj.get("helpBlockFieldCode"),
            "defaultValue": obj.get("defaultValue"),
            "optionSource": obj.get("optionSource"),
            "optionSourceType": obj.get("optionSourceType"),
            "optionList": obj.get("optionList"),
            "type": obj.get("type"),
            "advanced": obj.get("advanced"),
            "required": obj.get("required"),
            "exportMeta": obj.get("exportMeta"),
            "editable": obj.get("editable"),
            "creatable": obj.get("creatable"),
            "config": obj.get("config"),
            "displayOrder": obj.get("displayOrder"),
            "wrapperClass": obj.get("wrapperClass"),
            "enabled": obj.get("enabled"),
            "noBlank": obj.get("noBlank"),
            "dependsOnCode": obj.get("dependsOnCode"),
            "visibleOnCode": obj.get("visibleOnCode"),
            "requireOnCode": obj.get("requireOnCode"),
            "contextualDefault": obj.get("contextualDefault"),
            "displayValueOnDetails": obj.get("displayValueOnDetails"),
            "showOnCreate": obj.get("showOnCreate"),
            "showOnEdit": obj.get("showOnEdit"),
            "localCredential": obj.get("localCredential")
        })
        return _obj


