# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_tenants200_response_all_of_accounts_inner_role import ListTenants200ResponseAllOfAccountsInnerRole
from morpheus.models.list_tenants200_response_all_of_accounts_inner_stats import ListTenants200ResponseAllOfAccountsInnerStats
from typing import Optional, Set
from typing_extensions import Self

class ListTenants200ResponseAllOfAccountsInner(BaseModel):
    """
    ListTenants200ResponseAllOfAccountsInner
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    subdomain: Optional[StrictStr] = None
    currency: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    customer_number: Optional[StrictStr] = Field(default=None, alias="customerNumber")
    account_number: Optional[StrictStr] = Field(default=None, alias="accountNumber")
    account_name: Optional[StrictStr] = Field(default=None, alias="accountName")
    active: Optional[StrictBool] = None
    master: Optional[StrictBool] = None
    role: Optional[ListTenants200ResponseAllOfAccountsInnerRole] = None
    stats: Optional[ListTenants200ResponseAllOfAccountsInnerStats] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "subdomain", "currency", "externalId", "customerNumber", "accountNumber", "accountName", "active", "master", "role", "stats", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListTenants200ResponseAllOfAccountsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of role
        if self.role:
            _dict['role'] = self.role.to_dict()
        # override the default output from pydantic by calling `to_dict()` of stats
        if self.stats:
            _dict['stats'] = self.stats.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if customer_number (nullable) is None
        # and model_fields_set contains the field
        if self.customer_number is None and "customer_number" in self.model_fields_set:
            _dict['customerNumber'] = None

        # set to None if account_number (nullable) is None
        # and model_fields_set contains the field
        if self.account_number is None and "account_number" in self.model_fields_set:
            _dict['accountNumber'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListTenants200ResponseAllOfAccountsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "subdomain": obj.get("subdomain"),
            "currency": obj.get("currency"),
            "externalId": obj.get("externalId"),
            "customerNumber": obj.get("customerNumber"),
            "accountNumber": obj.get("accountNumber"),
            "accountName": obj.get("accountName"),
            "active": obj.get("active"),
            "master": obj.get("master"),
            "role": ListTenants200ResponseAllOfAccountsInnerRole.from_dict(obj["role"]) if obj.get("role") is not None else None,
            "stats": ListTenants200ResponseAllOfAccountsInnerStats.from_dict(obj["stats"]) if obj.get("stats") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


