# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ListWorkflows200ResponseAllOfTaskSetsInnerTaskSetTasksInnerTaskTaskOptions(BaseModel):
    """
    ListWorkflows200ResponseAllOfTaskSetsInnerTaskSetTasksInnerTaskTaskOptions
    """ # noqa: E501
    local_script_git_ref: Optional[StrictStr] = Field(default=None, alias="localScriptGitRef")
    username: Optional[StrictStr] = None
    local_script_git_id: Optional[StrictStr] = Field(default=None, alias="localScriptGitId")
    host: Optional[StrictStr] = None
    ssh_key: Optional[StrictStr] = Field(default=None, alias="sshKey")
    port: Optional[StrictStr] = None
    password: Optional[StrictStr] = None
    password_hash: Optional[StrictStr] = Field(default=None, alias="passwordHash")
    shell_sudo: Optional[StrictStr] = Field(default=None, alias="shell.sudo")
    __properties: ClassVar[List[str]] = ["localScriptGitRef", "username", "localScriptGitId", "host", "sshKey", "port", "password", "passwordHash", "shell.sudo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ListWorkflows200ResponseAllOfTaskSetsInnerTaskSetTasksInnerTaskTaskOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if local_script_git_ref (nullable) is None
        # and model_fields_set contains the field
        if self.local_script_git_ref is None and "local_script_git_ref" in self.model_fields_set:
            _dict['localScriptGitRef'] = None

        # set to None if username (nullable) is None
        # and model_fields_set contains the field
        if self.username is None and "username" in self.model_fields_set:
            _dict['username'] = None

        # set to None if local_script_git_id (nullable) is None
        # and model_fields_set contains the field
        if self.local_script_git_id is None and "local_script_git_id" in self.model_fields_set:
            _dict['localScriptGitId'] = None

        # set to None if host (nullable) is None
        # and model_fields_set contains the field
        if self.host is None and "host" in self.model_fields_set:
            _dict['host'] = None

        # set to None if ssh_key (nullable) is None
        # and model_fields_set contains the field
        if self.ssh_key is None and "ssh_key" in self.model_fields_set:
            _dict['sshKey'] = None

        # set to None if port (nullable) is None
        # and model_fields_set contains the field
        if self.port is None and "port" in self.model_fields_set:
            _dict['port'] = None

        # set to None if password (nullable) is None
        # and model_fields_set contains the field
        if self.password is None and "password" in self.model_fields_set:
            _dict['password'] = None

        # set to None if password_hash (nullable) is None
        # and model_fields_set contains the field
        if self.password_hash is None and "password_hash" in self.model_fields_set:
            _dict['passwordHash'] = None

        # set to None if shell_sudo (nullable) is None
        # and model_fields_set contains the field
        if self.shell_sudo is None and "shell_sudo" in self.model_fields_set:
            _dict['shell.sudo'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ListWorkflows200ResponseAllOfTaskSetsInnerTaskSetTasksInnerTaskTaskOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "localScriptGitRef": obj.get("localScriptGitRef"),
            "username": obj.get("username"),
            "localScriptGitId": obj.get("localScriptGitId"),
            "host": obj.get("host"),
            "sshKey": obj.get("sshKey"),
            "port": obj.get("port"),
            "password": obj.get("password"),
            "passwordHash": obj.get("passwordHash"),
            "shell.sudo": obj.get("shell.sudo")
        })
        return _obj


