# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_monitoring_settings200_response_monitoring_settings_service_now import GetMonitoringSettings200ResponseMonitoringSettingsServiceNow
from typing import Optional, Set
from typing_extensions import Self

class MonitoringSettings(BaseModel):
    """
    MonitoringSettings
    """ # noqa: E501
    auto_manage_checks: Optional[StrictBool] = Field(default=None, description="Auto Create Checks", alias="autoManageChecks")
    availability_time_frame: Optional[StrictInt] = Field(default=None, description="Availability Time Frame. The number of days availability should be calculated for. Changes will not take effect until your checks have passed their check interval.", alias="availabilityTimeFrame")
    availability_precision: Optional[StrictInt] = Field(default=None, description="Availability Precision. The number of decimal places availability should be displayed in. Can be anywhere between 0 and 5.", alias="availabilityPrecision")
    default_check_interval: Optional[StrictInt] = Field(default=None, description="Default Check Interval. The number of minutes to use as the default interval to use when creating new checks.", alias="defaultCheckInterval")
    service_now: Optional[GetMonitoringSettings200ResponseMonitoringSettingsServiceNow] = Field(default=None, alias="serviceNow")
    __properties: ClassVar[List[str]] = ["autoManageChecks", "availabilityTimeFrame", "availabilityPrecision", "defaultCheckInterval", "serviceNow"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MonitoringSettings from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of service_now
        if self.service_now:
            _dict['serviceNow'] = self.service_now.to_dict()
        # set to None if availability_time_frame (nullable) is None
        # and model_fields_set contains the field
        if self.availability_time_frame is None and "availability_time_frame" in self.model_fields_set:
            _dict['availabilityTimeFrame'] = None

        # set to None if availability_precision (nullable) is None
        # and model_fields_set contains the field
        if self.availability_precision is None and "availability_precision" in self.model_fields_set:
            _dict['availabilityPrecision'] = None

        # set to None if default_check_interval (nullable) is None
        # and model_fields_set contains the field
        if self.default_check_interval is None and "default_check_interval" in self.model_fields_set:
            _dict['defaultCheckInterval'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MonitoringSettings from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "autoManageChecks": obj.get("autoManageChecks"),
            "availabilityTimeFrame": obj.get("availabilityTimeFrame"),
            "availabilityPrecision": obj.get("availabilityPrecision"),
            "defaultCheckInterval": obj.get("defaultCheckInterval"),
            "serviceNow": GetMonitoringSettings200ResponseMonitoringSettingsServiceNow.from_dict(obj["serviceNow"]) if obj.get("serviceNow") is not None else None
        })
        return _obj


