# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class NetworkServerGroupMember(BaseModel):
    """
    NetworkServerGroupMember
    """ # noqa: E501
    id: Optional[StrictInt] = None
    category: Optional[StrictStr] = None
    type: Optional[StrictStr] = None
    member_name: Optional[StrictStr] = Field(default=None, alias="memberName")
    member_type: Optional[StrictStr] = Field(default=None, alias="memberType")
    member_value: Optional[StrictStr] = Field(default=None, alias="memberValue")
    member_expression: Optional[StrictStr] = Field(default=None, alias="memberExpression")
    display_order: Optional[StrictInt] = Field(default=None, alias="displayOrder")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    members: Optional[List[Dict[str, Any]]] = None
    __properties: ClassVar[List[str]] = ["id", "category", "type", "memberName", "memberType", "memberValue", "memberExpression", "displayOrder", "internalId", "externalId", "members"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of NetworkServerGroupMember from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if member_name (nullable) is None
        # and model_fields_set contains the field
        if self.member_name is None and "member_name" in self.model_fields_set:
            _dict['memberName'] = None

        # set to None if member_type (nullable) is None
        # and model_fields_set contains the field
        if self.member_type is None and "member_type" in self.model_fields_set:
            _dict['memberType'] = None

        # set to None if member_value (nullable) is None
        # and model_fields_set contains the field
        if self.member_value is None and "member_value" in self.model_fields_set:
            _dict['memberValue'] = None

        # set to None if member_expression (nullable) is None
        # and model_fields_set contains the field
        if self.member_expression is None and "member_expression" in self.model_fields_set:
            _dict['memberExpression'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of NetworkServerGroupMember from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "category": obj.get("category"),
            "type": obj.get("type"),
            "memberName": obj.get("memberName"),
            "memberType": obj.get("memberType"),
            "memberValue": obj.get("memberValue"),
            "memberExpression": obj.get("memberExpression"),
            "displayOrder": obj.get("displayOrder"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "members": obj.get("members")
        })
        return _obj


