# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.get_resource_pool_groups200_response_resource_pool_groups_inner_resource_permission import GetResourcePoolGroups200ResponseResourcePoolGroupsInnerResourcePermission
from typing import Optional, Set
from typing_extensions import Self

class ResourcePoolGroupsCreateInput(BaseModel):
    """
    ResourcePoolGroupsCreateInput
    """ # noqa: E501
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    visibility: Optional[StrictStr] = None
    mode: Optional[StrictStr] = Field(default=None, description="Pool selection mode. Valid values are `roundrobin` or `availablecapacity`.")
    pools: Optional[List[StrictInt]] = None
    tenants: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    resource_permission: Optional[GetResourcePoolGroups200ResponseResourcePoolGroupsInnerResourcePermission] = Field(default=None, alias="resourcePermission")
    __properties: ClassVar[List[str]] = ["name", "description", "visibility", "mode", "pools", "tenants", "resourcePermission"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ResourcePoolGroupsCreateInput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_permission
        if self.resource_permission:
            _dict['resourcePermission'] = self.resource_permission.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ResourcePoolGroupsCreateInput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "visibility": obj.get("visibility"),
            "mode": obj.get("mode"),
            "pools": obj.get("pools"),
            "tenants": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None,
            "resourcePermission": GetResourcePoolGroups200ResponseResourcePoolGroupsInnerResourcePermission.from_dict(obj["resourcePermission"]) if obj.get("resourcePermission") is not None else None
        })
        return _obj


