# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, SecretStr, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class SetupRequestAnyOf(BaseModel):
    """
    SetupRequestAnyOf
    """ # noqa: E501
    appliance_name: StrictStr = Field(description="Appliance Name. Choose a name for your Morpheus Appliance.  This is stored in the Appliance Settings.", alias="applianceName")
    appliance_url: Optional[StrictStr] = Field(default=None, description="Appliance URL. Specify the full URL for your Morpheus Appliance. This is stored in the Appliance Settings.", alias="applianceUrl")
    account_name: StrictStr = Field(description="Name of the Master Tenant account being created.", alias="accountName")
    first_name: Optional[StrictStr] = Field(default=None, description="First Name for the System Admin user being created.", alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, description="Last Name for the System Admin user being created.", alias="lastName")
    username: StrictStr = Field(description="Username for the System Admin user being created.")
    email: StrictStr = Field(description="Email for the System Admin user being created.")
    password: SecretStr = Field(description="Password for the System Admin user being created.")
    hubmode: Optional[StrictStr] = Field(default='skip', description="Hub Mode. Determines if and how the appliance should connect with the Morpheus Hub. The default value (skip) means do not connect with the hub, and you will be installing your license manually. If you login or register with the hub then a Community Edition license will be installed automatically.")
    license_key: Optional[StrictStr] = Field(default=None, description="License Key to install on setup.", alias="licenseKey")
    __properties: ClassVar[List[str]] = ["applianceName", "applianceUrl", "accountName", "firstName", "lastName", "username", "email", "password", "hubmode", "licenseKey"]

    @field_validator('hubmode')
    def hubmode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['skip', 'register', 'login']):
            raise ValueError("must be one of enum values ('skip', 'register', 'login')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SetupRequestAnyOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SetupRequestAnyOf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "applianceName": obj.get("applianceName"),
            "applianceUrl": obj.get("applianceUrl"),
            "accountName": obj.get("accountName"),
            "firstName": obj.get("firstName"),
            "lastName": obj.get("lastName"),
            "username": obj.get("username"),
            "email": obj.get("email"),
            "password": obj.get("password"),
            "hubmode": obj.get("hubmode") if obj.get("hubmode") is not None else 'skip',
            "licenseKey": obj.get("licenseKey")
        })
        return _obj


