# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from morpheus.models.list_cluster_layouts200_response_all_of_layouts_inner_spec_templates_inner_file import ListClusterLayouts200ResponseAllOfLayoutsInnerSpecTemplatesInnerFile
from typing import Optional, Set
from typing_extensions import Self

class SpecTemplate(BaseModel):
    """
    SpecTemplate
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    code: Optional[StrictStr] = None
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    external_type: Optional[StrictStr] = Field(default=None, alias="externalType")
    deployment_id: Optional[StrictStr] = Field(default=None, alias="deploymentId")
    status: Optional[StrictStr] = None
    file: Optional[ListClusterLayouts200ResponseAllOfLayoutsInnerSpecTemplatesInnerFile] = None
    config: Optional[Dict[str, Any]] = None
    created_by: Optional[StrictStr] = Field(default=None, alias="createdBy")
    updated_by: Optional[StrictStr] = Field(default=None, alias="updatedBy")
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "account", "name", "labels", "code", "type", "externalId", "externalType", "deploymentId", "status", "file", "config", "createdBy", "updatedBy", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SpecTemplate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if external_id (nullable) is None
        # and model_fields_set contains the field
        if self.external_id is None and "external_id" in self.model_fields_set:
            _dict['externalId'] = None

        # set to None if external_type (nullable) is None
        # and model_fields_set contains the field
        if self.external_type is None and "external_type" in self.model_fields_set:
            _dict['externalType'] = None

        # set to None if deployment_id (nullable) is None
        # and model_fields_set contains the field
        if self.deployment_id is None and "deployment_id" in self.model_fields_set:
            _dict['deploymentId'] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict['status'] = None

        # set to None if updated_by (nullable) is None
        # and model_fields_set contains the field
        if self.updated_by is None and "updated_by" in self.model_fields_set:
            _dict['updatedBy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SpecTemplate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "code": obj.get("code"),
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "externalId": obj.get("externalId"),
            "externalType": obj.get("externalType"),
            "deploymentId": obj.get("deploymentId"),
            "status": obj.get("status"),
            "file": ListClusterLayouts200ResponseAllOfLayoutsInnerSpecTemplatesInnerFile.from_dict(obj["file"]) if obj.get("file") is not None else None,
            "config": obj.get("config"),
            "createdBy": obj.get("createdBy"),
            "updatedBy": obj.get("updatedBy"),
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


