# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class StorageVolume(BaseModel):
    """
    StorageVolume
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    controller: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    controller_id: Optional[StrictInt] = Field(default=None, alias="controllerId")
    controller_mount_point: Optional[StrictStr] = Field(default=None, alias="controllerMountPoint")
    resizeable: Optional[StrictBool] = None
    root_volume: Optional[StrictBool] = Field(default=None, alias="rootVolume")
    unit_number: Optional[StrictStr] = Field(default=None, alias="unitNumber")
    device_name: Optional[StrictStr] = Field(default=None, alias="deviceName")
    device_display_name: Optional[StrictStr] = Field(default=None, alias="deviceDisplayName")
    volume_name: Optional[StrictStr] = Field(default=None, alias="volumeName")
    volume_path: Optional[StrictStr] = Field(default=None, alias="volumePath")
    volume_type: Optional[StrictStr] = Field(default=None, alias="volumeType")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    ref_id: Optional[StrictInt] = Field(default=None, alias="refId")
    disk_mode: Optional[StrictStr] = Field(default=None, alias="diskMode")
    disk_type: Optional[StrictStr] = Field(default=None, alias="diskType")
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    type_id: Optional[StrictInt] = Field(default=None, alias="typeId")
    category: Optional[StrictStr] = None
    status: Optional[StrictStr] = None
    status_message: Optional[StrictStr] = Field(default=None, alias="statusMessage")
    configurable_iops: Optional[StrictBool] = Field(default=None, alias="configurableIOPS")
    max_storage: Optional[StrictInt] = Field(default=None, alias="maxStorage")
    used_storage: Optional[StrictInt] = Field(default=None, alias="usedStorage")
    display_order: Optional[StrictInt] = Field(default=None, alias="displayOrder")
    max_iops: Optional[StrictStr] = Field(default=None, alias="maxIOPS")
    uuid: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    read_only: Optional[StrictBool] = Field(default=None, alias="readOnly")
    removable: Optional[StrictBool] = None
    pool_name: Optional[StrictStr] = Field(default=None, alias="poolName")
    zone: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    zone_id: Optional[StrictInt] = Field(default=None, alias="zoneId")
    datastore: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    datastore_id: Optional[StrictInt] = Field(default=None, alias="datastoreId")
    datastore_option: Optional[StrictStr] = Field(default=None, alias="datastoreOption")
    storage_group: Optional[StrictStr] = Field(default=None, alias="storageGroup")
    namespace: Optional[StrictStr] = None
    storage_server: Optional[StrictStr] = Field(default=None, alias="storageServer")
    source: Optional[StrictStr] = None
    unique_id: Optional[StrictStr] = Field(default=None, alias="uniqueId")
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    provision_type: Optional[StrictStr] = Field(default=None, alias="provisionType")
    copy_type: Optional[StrictStr] = Field(default=None, alias="copyType")
    fiber_wwn: Optional[StrictStr] = Field(default=None, alias="fiberWwn")
    file_name: Optional[StrictStr] = Field(default=None, alias="fileName")
    claim_name: Optional[StrictStr] = Field(default=None, alias="claimName")
    share_path: Optional[StrictStr] = Field(default=None, alias="sharePath")
    source_id: Optional[StrictStr] = Field(default=None, alias="sourceId")
    source_image: Optional[StrictStr] = Field(default=None, alias="sourceImage")
    image_type: Optional[StrictStr] = Field(default=None, alias="imageType")
    online: Optional[StrictBool] = None
    raw_data: Optional[StrictStr] = Field(default=None, alias="rawData")
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    owner: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    __properties: ClassVar[List[str]] = ["id", "name", "description", "controller", "controllerId", "controllerMountPoint", "resizeable", "rootVolume", "unitNumber", "deviceName", "deviceDisplayName", "volumeName", "volumePath", "volumeType", "refType", "refId", "diskMode", "diskType", "type", "typeId", "category", "status", "statusMessage", "configurableIOPS", "maxStorage", "usedStorage", "displayOrder", "maxIOPS", "uuid", "active", "readOnly", "removable", "poolName", "zone", "zoneId", "datastore", "datastoreId", "datastoreOption", "storageGroup", "namespace", "storageServer", "source", "uniqueId", "internalId", "externalId", "provisionType", "copyType", "fiberWwn", "fileName", "claimName", "sharePath", "sourceId", "sourceImage", "imageType", "online", "rawData", "account", "owner"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StorageVolume from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of controller
        if self.controller:
            _dict['controller'] = self.controller.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of datastore
        if self.datastore:
            _dict['datastore'] = self.datastore.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of owner
        if self.owner:
            _dict['owner'] = self.owner.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if controller_id (nullable) is None
        # and model_fields_set contains the field
        if self.controller_id is None and "controller_id" in self.model_fields_set:
            _dict['controllerId'] = None

        # set to None if controller_mount_point (nullable) is None
        # and model_fields_set contains the field
        if self.controller_mount_point is None and "controller_mount_point" in self.model_fields_set:
            _dict['controllerMountPoint'] = None

        # set to None if resizeable (nullable) is None
        # and model_fields_set contains the field
        if self.resizeable is None and "resizeable" in self.model_fields_set:
            _dict['resizeable'] = None

        # set to None if unit_number (nullable) is None
        # and model_fields_set contains the field
        if self.unit_number is None and "unit_number" in self.model_fields_set:
            _dict['unitNumber'] = None

        # set to None if status_message (nullable) is None
        # and model_fields_set contains the field
        if self.status_message is None and "status_message" in self.model_fields_set:
            _dict['statusMessage'] = None

        # set to None if max_iops (nullable) is None
        # and model_fields_set contains the field
        if self.max_iops is None and "max_iops" in self.model_fields_set:
            _dict['maxIOPS'] = None

        # set to None if datastore_id (nullable) is None
        # and model_fields_set contains the field
        if self.datastore_id is None and "datastore_id" in self.model_fields_set:
            _dict['datastoreId'] = None

        # set to None if storage_group (nullable) is None
        # and model_fields_set contains the field
        if self.storage_group is None and "storage_group" in self.model_fields_set:
            _dict['storageGroup'] = None

        # set to None if namespace (nullable) is None
        # and model_fields_set contains the field
        if self.namespace is None and "namespace" in self.model_fields_set:
            _dict['namespace'] = None

        # set to None if storage_server (nullable) is None
        # and model_fields_set contains the field
        if self.storage_server is None and "storage_server" in self.model_fields_set:
            _dict['storageServer'] = None

        # set to None if unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.unique_id is None and "unique_id" in self.model_fields_set:
            _dict['uniqueId'] = None

        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if provision_type (nullable) is None
        # and model_fields_set contains the field
        if self.provision_type is None and "provision_type" in self.model_fields_set:
            _dict['provisionType'] = None

        # set to None if copy_type (nullable) is None
        # and model_fields_set contains the field
        if self.copy_type is None and "copy_type" in self.model_fields_set:
            _dict['copyType'] = None

        # set to None if fiber_wwn (nullable) is None
        # and model_fields_set contains the field
        if self.fiber_wwn is None and "fiber_wwn" in self.model_fields_set:
            _dict['fiberWwn'] = None

        # set to None if file_name (nullable) is None
        # and model_fields_set contains the field
        if self.file_name is None and "file_name" in self.model_fields_set:
            _dict['fileName'] = None

        # set to None if claim_name (nullable) is None
        # and model_fields_set contains the field
        if self.claim_name is None and "claim_name" in self.model_fields_set:
            _dict['claimName'] = None

        # set to None if share_path (nullable) is None
        # and model_fields_set contains the field
        if self.share_path is None and "share_path" in self.model_fields_set:
            _dict['sharePath'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StorageVolume from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "controller": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["controller"]) if obj.get("controller") is not None else None,
            "controllerId": obj.get("controllerId"),
            "controllerMountPoint": obj.get("controllerMountPoint"),
            "resizeable": obj.get("resizeable"),
            "rootVolume": obj.get("rootVolume"),
            "unitNumber": obj.get("unitNumber"),
            "deviceName": obj.get("deviceName"),
            "deviceDisplayName": obj.get("deviceDisplayName"),
            "volumeName": obj.get("volumeName"),
            "volumePath": obj.get("volumePath"),
            "volumeType": obj.get("volumeType"),
            "refType": obj.get("refType"),
            "refId": obj.get("refId"),
            "diskMode": obj.get("diskMode"),
            "diskType": obj.get("diskType"),
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "typeId": obj.get("typeId"),
            "category": obj.get("category"),
            "status": obj.get("status"),
            "statusMessage": obj.get("statusMessage"),
            "configurableIOPS": obj.get("configurableIOPS"),
            "maxStorage": obj.get("maxStorage"),
            "usedStorage": obj.get("usedStorage"),
            "displayOrder": obj.get("displayOrder"),
            "maxIOPS": obj.get("maxIOPS"),
            "uuid": obj.get("uuid"),
            "active": obj.get("active"),
            "readOnly": obj.get("readOnly"),
            "removable": obj.get("removable"),
            "poolName": obj.get("poolName"),
            "zone": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "zoneId": obj.get("zoneId"),
            "datastore": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["datastore"]) if obj.get("datastore") is not None else None,
            "datastoreId": obj.get("datastoreId"),
            "datastoreOption": obj.get("datastoreOption"),
            "storageGroup": obj.get("storageGroup"),
            "namespace": obj.get("namespace"),
            "storageServer": obj.get("storageServer"),
            "source": obj.get("source"),
            "uniqueId": obj.get("uniqueId"),
            "internalId": obj.get("internalId"),
            "externalId": obj.get("externalId"),
            "provisionType": obj.get("provisionType"),
            "copyType": obj.get("copyType"),
            "fiberWwn": obj.get("fiberWwn"),
            "fileName": obj.get("fileName"),
            "claimName": obj.get("claimName"),
            "sharePath": obj.get("sharePath"),
            "sourceId": obj.get("sourceId"),
            "sourceImage": obj.get("sourceImage"),
            "imageType": obj.get("imageType"),
            "online": obj.get("online"),
            "rawData": obj.get("rawData"),
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "owner": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["owner"]) if obj.get("owner") is not None else None
        })
        return _obj


