# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.get_app_state200_response_all_of_input_providers_inner import GetAppState200ResponseAllOfInputProvidersInner
from morpheus.models.get_network_subnets200_response_all_of_subnets_inner_resource_permission import GetNetworkSubnets200ResponseAllOfSubnetsInnerResourcePermission
from morpheus.models.list_backup_settings200_response_backup_settings_default_schedule import ListBackupSettings200ResponseBackupSettingsDefaultSchedule
from typing import Optional, Set
from typing_extensions import Self

class Subnet(BaseModel):
    """
    Subnet
    """ # noqa: E501
    id: Optional[StrictInt] = None
    code: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    labels: Optional[List[StrictStr]] = None
    active: Optional[StrictBool] = None
    description: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    unique_id: Optional[StrictStr] = Field(default=None, alias="uniqueId")
    address_prefix: Optional[StrictStr] = Field(default=None, alias="addressPrefix")
    cidr: Optional[StrictStr] = None
    gateway: Optional[StrictStr] = None
    netmask: Optional[StrictStr] = None
    subnet_address: Optional[StrictStr] = Field(default=None, alias="subnetAddress")
    tftp_server: Optional[StrictStr] = Field(default=None, alias="tftpServer")
    boot_file: Optional[StrictStr] = Field(default=None, alias="bootFile")
    pool: Optional[StrictStr] = None
    dhcp_server: Optional[StrictBool] = Field(default=None, alias="dhcpServer")
    has_floating_ips: Optional[StrictBool] = Field(default=None, alias="hasFloatingIps")
    dhcp_ip: Optional[StrictStr] = Field(default=None, alias="dhcpIp")
    dns_primary: Optional[StrictStr] = Field(default=None, alias="dnsPrimary")
    dns_secondary: Optional[StrictStr] = Field(default=None, alias="dnsSecondary")
    dhcp_start: Optional[StrictStr] = Field(default=None, alias="dhcpStart")
    dhcp_end: Optional[StrictStr] = Field(default=None, alias="dhcpEnd")
    dhcp_range: Optional[StrictStr] = Field(default=None, alias="dhcpRange")
    network_proxy: Optional[StrictStr] = Field(default=None, alias="networkProxy")
    network_domain: Optional[StrictStr] = Field(default=None, alias="networkDomain")
    search_domains: Optional[StrictStr] = Field(default=None, alias="searchDomains")
    default_network: Optional[StrictBool] = Field(default=None, alias="defaultNetwork")
    assign_public_ip: Optional[StrictBool] = Field(default=None, alias="assignPublicIp")
    visibility: Optional[StrictStr] = None
    status: Optional[GetAppState200ResponseAllOfInputProvidersInner] = None
    network: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    type: Optional[ListBackupSettings200ResponseBackupSettingsDefaultSchedule] = None
    account: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    security_groups: Optional[List[Dict[str, Any]]] = Field(default=None, alias="securityGroups")
    tenants: Optional[List[GetAlerts200ResponseAllOfCheckGroupsInnerInstance]] = None
    resource_permission: Optional[GetNetworkSubnets200ResponseAllOfSubnetsInnerResourcePermission] = Field(default=None, alias="resourcePermission")
    __properties: ClassVar[List[str]] = ["id", "code", "name", "labels", "active", "description", "externalId", "uniqueId", "addressPrefix", "cidr", "gateway", "netmask", "subnetAddress", "tftpServer", "bootFile", "pool", "dhcpServer", "hasFloatingIps", "dhcpIp", "dnsPrimary", "dnsSecondary", "dhcpStart", "dhcpEnd", "dhcpRange", "networkProxy", "networkDomain", "searchDomains", "defaultNetwork", "assignPublicIp", "visibility", "status", "network", "type", "account", "securityGroups", "tenants", "resourcePermission"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Subnet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of network
        if self.network:
            _dict['network'] = self.network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of account
        if self.account:
            _dict['account'] = self.account.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_permission
        if self.resource_permission:
            _dict['resourcePermission'] = self.resource_permission.to_dict()
        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if unique_id (nullable) is None
        # and model_fields_set contains the field
        if self.unique_id is None and "unique_id" in self.model_fields_set:
            _dict['uniqueId'] = None

        # set to None if address_prefix (nullable) is None
        # and model_fields_set contains the field
        if self.address_prefix is None and "address_prefix" in self.model_fields_set:
            _dict['addressPrefix'] = None

        # set to None if gateway (nullable) is None
        # and model_fields_set contains the field
        if self.gateway is None and "gateway" in self.model_fields_set:
            _dict['gateway'] = None

        # set to None if tftp_server (nullable) is None
        # and model_fields_set contains the field
        if self.tftp_server is None and "tftp_server" in self.model_fields_set:
            _dict['tftpServer'] = None

        # set to None if boot_file (nullable) is None
        # and model_fields_set contains the field
        if self.boot_file is None and "boot_file" in self.model_fields_set:
            _dict['bootFile'] = None

        # set to None if pool (nullable) is None
        # and model_fields_set contains the field
        if self.pool is None and "pool" in self.model_fields_set:
            _dict['pool'] = None

        # set to None if dhcp_ip (nullable) is None
        # and model_fields_set contains the field
        if self.dhcp_ip is None and "dhcp_ip" in self.model_fields_set:
            _dict['dhcpIp'] = None

        # set to None if dns_primary (nullable) is None
        # and model_fields_set contains the field
        if self.dns_primary is None and "dns_primary" in self.model_fields_set:
            _dict['dnsPrimary'] = None

        # set to None if dns_secondary (nullable) is None
        # and model_fields_set contains the field
        if self.dns_secondary is None and "dns_secondary" in self.model_fields_set:
            _dict['dnsSecondary'] = None

        # set to None if dhcp_range (nullable) is None
        # and model_fields_set contains the field
        if self.dhcp_range is None and "dhcp_range" in self.model_fields_set:
            _dict['dhcpRange'] = None

        # set to None if network_proxy (nullable) is None
        # and model_fields_set contains the field
        if self.network_proxy is None and "network_proxy" in self.model_fields_set:
            _dict['networkProxy'] = None

        # set to None if network_domain (nullable) is None
        # and model_fields_set contains the field
        if self.network_domain is None and "network_domain" in self.model_fields_set:
            _dict['networkDomain'] = None

        # set to None if search_domains (nullable) is None
        # and model_fields_set contains the field
        if self.search_domains is None and "search_domains" in self.model_fields_set:
            _dict['searchDomains'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Subnet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "code": obj.get("code"),
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "active": obj.get("active"),
            "description": obj.get("description"),
            "externalId": obj.get("externalId"),
            "uniqueId": obj.get("uniqueId"),
            "addressPrefix": obj.get("addressPrefix"),
            "cidr": obj.get("cidr"),
            "gateway": obj.get("gateway"),
            "netmask": obj.get("netmask"),
            "subnetAddress": obj.get("subnetAddress"),
            "tftpServer": obj.get("tftpServer"),
            "bootFile": obj.get("bootFile"),
            "pool": obj.get("pool"),
            "dhcpServer": obj.get("dhcpServer"),
            "hasFloatingIps": obj.get("hasFloatingIps"),
            "dhcpIp": obj.get("dhcpIp"),
            "dnsPrimary": obj.get("dnsPrimary"),
            "dnsSecondary": obj.get("dnsSecondary"),
            "dhcpStart": obj.get("dhcpStart"),
            "dhcpEnd": obj.get("dhcpEnd"),
            "dhcpRange": obj.get("dhcpRange"),
            "networkProxy": obj.get("networkProxy"),
            "networkDomain": obj.get("networkDomain"),
            "searchDomains": obj.get("searchDomains"),
            "defaultNetwork": obj.get("defaultNetwork"),
            "assignPublicIp": obj.get("assignPublicIp"),
            "visibility": obj.get("visibility"),
            "status": GetAppState200ResponseAllOfInputProvidersInner.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "network": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["network"]) if obj.get("network") is not None else None,
            "type": ListBackupSettings200ResponseBackupSettingsDefaultSchedule.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "account": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["account"]) if obj.get("account") is not None else None,
            "securityGroups": obj.get("securityGroups"),
            "tenants": [GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None,
            "resourcePermission": GetNetworkSubnets200ResponseAllOfSubnetsInnerResourcePermission.from_dict(obj["resourcePermission"]) if obj.get("resourcePermission") is not None else None
        })
        return _obj


