# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_clouds200_response_all_of_zones_inner_credential_any_of import ListClouds200ResponseAllOfZonesInnerCredentialAnyOf
from morpheus.models.list_tasks200_response_all_of_tasks_inner_any_of16_task_options import ListTasks200ResponseAllOfTasksInnerAnyOf16TaskOptions
from morpheus.models.list_tasks200_response_all_of_tasks_inner_any_of16_task_type import ListTasks200ResponseAllOfTasksInnerAnyOf16TaskType
from morpheus.models.list_tasks200_response_all_of_tasks_inner_any_of_file import ListTasks200ResponseAllOfTasksInnerAnyOfFile
from typing import Optional, Set
from typing_extensions import Self

class TaskWriteAttributesConfig(BaseModel):
    """
    TaskWriteAttributesConfig
    """ # noqa: E501
    id: Optional[StrictInt] = None
    account_id: Optional[StrictInt] = Field(default=None, alias="accountId")
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    task_type: Optional[ListTasks200ResponseAllOfTasksInnerAnyOf16TaskType] = Field(default=None, alias="taskType")
    labels: Optional[List[StrictStr]] = None
    visibility: Optional[StrictStr] = None
    task_options: Optional[ListTasks200ResponseAllOfTasksInnerAnyOf16TaskOptions] = Field(default=None, alias="taskOptions")
    file: Optional[ListTasks200ResponseAllOfTasksInnerAnyOfFile] = None
    result_type: Optional[StrictStr] = Field(default=None, alias="resultType")
    execute_target: Optional[StrictStr] = Field(default=None, alias="executeTarget")
    retryable: Optional[StrictBool] = None
    retry_count: Optional[StrictInt] = Field(default=None, alias="retryCount")
    retry_delay_seconds: Optional[StrictInt] = Field(default=None, alias="retryDelaySeconds")
    allow_custom_config: Optional[StrictBool] = Field(default=None, alias="allowCustomConfig")
    credential: Optional[ListClouds200ResponseAllOfZonesInnerCredentialAnyOf] = None
    date_created: Optional[datetime] = Field(default=None, alias="dateCreated")
    last_updated: Optional[datetime] = Field(default=None, alias="lastUpdated")
    __properties: ClassVar[List[str]] = ["id", "accountId", "name", "code", "taskType", "labels", "visibility", "taskOptions", "file", "resultType", "executeTarget", "retryable", "retryCount", "retryDelaySeconds", "allowCustomConfig", "credential", "dateCreated", "lastUpdated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TaskWriteAttributesConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of task_type
        if self.task_type:
            _dict['taskType'] = self.task_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of task_options
        if self.task_options:
            _dict['taskOptions'] = self.task_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of file
        if self.file:
            _dict['file'] = self.file.to_dict()
        # override the default output from pydantic by calling `to_dict()` of credential
        if self.credential:
            _dict['credential'] = self.credential.to_dict()
        # set to None if code (nullable) is None
        # and model_fields_set contains the field
        if self.code is None and "code" in self.model_fields_set:
            _dict['code'] = None

        # set to None if result_type (nullable) is None
        # and model_fields_set contains the field
        if self.result_type is None and "result_type" in self.model_fields_set:
            _dict['resultType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TaskWriteAttributesConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "accountId": obj.get("accountId"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "taskType": ListTasks200ResponseAllOfTasksInnerAnyOf16TaskType.from_dict(obj["taskType"]) if obj.get("taskType") is not None else None,
            "labels": obj.get("labels"),
            "visibility": obj.get("visibility"),
            "taskOptions": ListTasks200ResponseAllOfTasksInnerAnyOf16TaskOptions.from_dict(obj["taskOptions"]) if obj.get("taskOptions") is not None else None,
            "file": ListTasks200ResponseAllOfTasksInnerAnyOfFile.from_dict(obj["file"]) if obj.get("file") is not None else None,
            "resultType": obj.get("resultType"),
            "executeTarget": obj.get("executeTarget"),
            "retryable": obj.get("retryable"),
            "retryCount": obj.get("retryCount"),
            "retryDelaySeconds": obj.get("retryDelaySeconds"),
            "allowCustomConfig": obj.get("allowCustomConfig"),
            "credential": ListClouds200ResponseAllOfZonesInnerCredentialAnyOf.from_dict(obj["credential"]) if obj.get("credential") is not None else None,
            "dateCreated": obj.get("dateCreated"),
            "lastUpdated": obj.get("lastUpdated")
        })
        return _obj


