# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_cloud_datastores200_response_all_of_datastores_inner_resource_permission import ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission
from morpheus.models.list_cloud_datastores200_response_all_of_datastores_inner_tenants_inner import ListCloudDatastores200ResponseAllOfDatastoresInnerTenantsInner
from typing import Optional, Set
from typing_extensions import Self

class UpdateCloudFolders200ResponseFolder(BaseModel):
    """
    UpdateCloudFolders200ResponseFolder
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    zone: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    parent: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    type: Optional[StrictStr] = None
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    visibility: Optional[StrictStr] = None
    read_only: Optional[StrictBool] = Field(default=None, alias="readOnly")
    default_folder: Optional[StrictBool] = Field(default=None, alias="defaultFolder")
    default_store: Optional[StrictBool] = Field(default=None, alias="defaultStore")
    active: Optional[StrictBool] = None
    tenants: Optional[List[ListCloudDatastores200ResponseAllOfDatastoresInnerTenantsInner]] = None
    resource_permissions: Optional[ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission] = Field(default=None, alias="resourcePermissions")
    depth: Optional[StrictInt] = None
    success: Optional[StrictBool] = None
    __properties: ClassVar[List[str]] = ["id", "name", "zone", "parent", "type", "externalId", "visibility", "readOnly", "defaultFolder", "defaultStore", "active", "tenants", "resourcePermissions", "depth", "success"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateCloudFolders200ResponseFolder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parent
        if self.parent:
            _dict['parent'] = self.parent.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_permissions
        if self.resource_permissions:
            _dict['resourcePermissions'] = self.resource_permissions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateCloudFolders200ResponseFolder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "zone": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "parent": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["parent"]) if obj.get("parent") is not None else None,
            "type": obj.get("type"),
            "externalId": obj.get("externalId"),
            "visibility": obj.get("visibility"),
            "readOnly": obj.get("readOnly"),
            "defaultFolder": obj.get("defaultFolder"),
            "defaultStore": obj.get("defaultStore"),
            "active": obj.get("active"),
            "tenants": [ListCloudDatastores200ResponseAllOfDatastoresInnerTenantsInner.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None,
            "resourcePermissions": ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission.from_dict(obj["resourcePermissions"]) if obj.get("resourcePermissions") is not None else None,
            "depth": obj.get("depth"),
            "success": obj.get("success")
        })
        return _obj


