# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.update_cloud_datastores_request_datastore_resource_permissions import UpdateCloudDatastoresRequestDatastoreResourcePermissions
from morpheus.models.update_cloud_folders_request_folder_tenant_permissions import UpdateCloudFoldersRequestFolderTenantPermissions
from typing import Optional, Set
from typing_extensions import Self

class UpdateCloudFoldersRequestFolder(BaseModel):
    """
    UpdateCloudFoldersRequestFolder
    """ # noqa: E501
    default_folder: Optional[StrictBool] = Field(default=False, alias="defaultFolder")
    default_image: Optional[StrictBool] = Field(default=False, alias="defaultImage")
    active: Optional[StrictBool] = Field(default=None, description="Activate `true` or disable `false` the folder")
    visibility: Optional[StrictStr] = Field(default='private', description="Setting `private` or `public`")
    tenant_permissions: Optional[UpdateCloudFoldersRequestFolderTenantPermissions] = Field(default=None, alias="tenantPermissions")
    resource_permissions: Optional[UpdateCloudDatastoresRequestDatastoreResourcePermissions] = Field(default=None, alias="resourcePermissions")
    __properties: ClassVar[List[str]] = ["defaultFolder", "defaultImage", "active", "visibility", "tenantPermissions", "resourcePermissions"]

    @field_validator('visibility')
    def visibility_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['public', 'private']):
            raise ValueError("must be one of enum values ('public', 'private')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateCloudFoldersRequestFolder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tenant_permissions
        if self.tenant_permissions:
            _dict['tenantPermissions'] = self.tenant_permissions.to_dict()
        # override the default output from pydantic by calling `to_dict()` of resource_permissions
        if self.resource_permissions:
            _dict['resourcePermissions'] = self.resource_permissions.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateCloudFoldersRequestFolder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "defaultFolder": obj.get("defaultFolder") if obj.get("defaultFolder") is not None else False,
            "defaultImage": obj.get("defaultImage") if obj.get("defaultImage") is not None else False,
            "active": obj.get("active"),
            "visibility": obj.get("visibility") if obj.get("visibility") is not None else 'private',
            "tenantPermissions": UpdateCloudFoldersRequestFolderTenantPermissions.from_dict(obj["tenantPermissions"]) if obj.get("tenantPermissions") is not None else None,
            "resourcePermissions": UpdateCloudDatastoresRequestDatastoreResourcePermissions.from_dict(obj["resourcePermissions"]) if obj.get("resourcePermissions") is not None else None
        })
        return _obj


