# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class UpdateClusterPackageRequestClusterPackage(BaseModel):
    """
    UpdateClusterPackageRequestClusterPackage
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Cluster Package name")
    description: Optional[StrictStr] = Field(default=None, description="Cluster Package description")
    code: Optional[StrictStr] = Field(default=None, description="Cluster Package code")
    package_version: Optional[StrictStr] = Field(default=None, description="Version of the cluster package", alias="packageVersion")
    package_type: Optional[StrictStr] = Field(default=None, description="Package Type", alias="packageType")
    type: Optional[StrictStr] = Field(default=None, description="type")
    enabled: Optional[StrictBool] = Field(default=True, description="Can be used to enable / disable the cluster package.")
    icon_path: Optional[StrictStr] = Field(default=None, description="Icon Path, relative location of an icon image, eg. /assets/containers-png/nginx.png.", alias="iconPath")
    spec_templates: Optional[List[GetAlerts200ResponseAllOfChecksInnerAccount]] = Field(default=None, description="Array of resource spec templates", alias="specTemplates")
    __properties: ClassVar[List[str]] = ["name", "description", "code", "packageVersion", "packageType", "type", "enabled", "iconPath", "specTemplates"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateClusterPackageRequestClusterPackage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in spec_templates (list)
        _items = []
        if self.spec_templates:
            for _item_spec_templates in self.spec_templates:
                if _item_spec_templates:
                    _items.append(_item_spec_templates.to_dict())
            _dict['specTemplates'] = _items
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateClusterPackageRequestClusterPackage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "code": obj.get("code"),
            "packageVersion": obj.get("packageVersion"),
            "packageType": obj.get("packageType"),
            "type": obj.get("type"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "iconPath": obj.get("iconPath"),
            "specTemplates": [GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(_item) for _item in obj["specTemplates"]] if obj.get("specTemplates") is not None else None
        })
        return _obj


