# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateIncidentsRequestIncident(BaseModel):
    """
    Payload for update an incident
    """ # noqa: E501
    resolution: Optional[StrictStr] = Field(default=None, description="Description of the resolution to this incident")
    comment: Optional[StrictStr] = Field(default=None, description="Comment on this incident, updates summary field")
    status: Optional[StrictStr] = Field(default=None, description="Set status")
    severity: Optional[StrictStr] = Field(default=None, description="Set severity")
    name: Optional[StrictStr] = Field(default=None, description="Set display name")
    start_date: Optional[datetime] = Field(default=None, description="Set start time", alias="startDate")
    end_date: Optional[datetime] = Field(default=None, description="Set start time", alias="endDate")
    in_uptime: Optional[StrictBool] = Field(default=None, description="Set 'In Availability'", alias="inUptime")
    __properties: ClassVar[List[str]] = ["resolution", "comment", "status", "severity", "name", "startDate", "endDate", "inUptime"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['open', 'closed']):
            raise ValueError("must be one of enum values ('open', 'closed')")
        return value

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['info', 'warning', 'critical']):
            raise ValueError("must be one of enum values ('info', 'warning', 'critical')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateIncidentsRequestIncident from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateIncidentsRequestIncident from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "resolution": obj.get("resolution"),
            "comment": obj.get("comment"),
            "status": obj.get("status"),
            "severity": obj.get("severity"),
            "name": obj.get("name"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "inUptime": obj.get("inUptime")
        })
        return _obj


