# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_checks_inner_account import GetAlerts200ResponseAllOfChecksInnerAccount
from typing import Optional, Set
from typing_extensions import Self

class UpdateInstanceNetworkInterface200ResponseAllOfOneOfNetworkInterface(BaseModel):
    """
    UpdateInstanceNetworkInterface200ResponseAllOfOneOfNetworkInterface
    """ # noqa: E501
    id: Optional[StrictInt] = None
    addresses: Optional[List[Dict[str, Any]]] = None
    internal_id: Optional[StrictStr] = Field(default=None, alias="internalId")
    interface_id: Optional[StrictStr] = Field(default=None, alias="interfaceId")
    display_order: Optional[StrictInt] = Field(default=None, alias="displayOrder")
    network_pool: Optional[Dict[str, Any]] = Field(default=None, alias="networkPool")
    dhcp: Optional[StrictBool] = None
    uuid: Optional[StrictStr] = None
    active: Optional[StrictBool] = None
    unique_id: Optional[StrictStr] = Field(default=None, alias="uniqueId")
    subnet: Optional[StrictStr] = None
    replace_host_record: Optional[StrictBool] = Field(default=None, alias="replaceHostRecord")
    ip_mode: Optional[StrictStr] = Field(default=None, alias="ipMode")
    version: Optional[StrictStr] = None
    ip_subnet: Optional[StrictStr] = Field(default=None, alias="ipSubnet")
    config: Optional[StrictStr] = None
    public_ip_address: Optional[StrictStr] = Field(default=None, alias="publicIpAddress")
    fabric_id: Optional[StrictStr] = Field(default=None, alias="fabricId")
    ipv6_subnet: Optional[StrictStr] = Field(default=None, alias="ipv6Subnet")
    mac_address: Optional[StrictStr] = Field(default=None, alias="macAddress")
    public_ipv6_address: Optional[StrictStr] = Field(default=None, alias="publicIpv6Address")
    ref_type: Optional[StrictStr] = Field(default=None, alias="refType")
    network_group: Optional[StrictStr] = Field(default=None, alias="networkGroup")
    ref_id: Optional[StrictStr] = Field(default=None, alias="refId")
    network_domain: Optional[StrictStr] = Field(default=None, alias="networkDomain")
    name: Optional[StrictStr] = None
    primary_interface: Optional[StrictBool] = Field(default=None, alias="primaryInterface")
    network_pool_ipv6: Optional[Dict[str, Any]] = Field(default=None, alias="networkPoolIPv6")
    network: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    vlan_id: Optional[StrictStr] = Field(default=None, alias="vlanId")
    type: Optional[GetAlerts200ResponseAllOfChecksInnerAccount] = None
    network_position: Optional[StrictStr] = Field(default=None, alias="networkPosition")
    pool_assigned: Optional[StrictBool] = Field(default=None, alias="poolAssigned")
    description: Optional[StrictStr] = None
    external_type: Optional[StrictStr] = Field(default=None, alias="externalType")
    external_id: Optional[StrictStr] = Field(default=None, alias="externalId")
    __properties: ClassVar[List[str]] = ["id", "addresses", "internalId", "interfaceId", "displayOrder", "networkPool", "dhcp", "uuid", "active", "uniqueId", "subnet", "replaceHostRecord", "ipMode", "version", "ipSubnet", "config", "publicIpAddress", "fabricId", "ipv6Subnet", "macAddress", "publicIpv6Address", "refType", "networkGroup", "refId", "networkDomain", "name", "primaryInterface", "networkPoolIPv6", "network", "vlanId", "type", "networkPosition", "poolAssigned", "description", "externalType", "externalId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateInstanceNetworkInterface200ResponseAllOfOneOfNetworkInterface from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of network
        if self.network:
            _dict['network'] = self.network.to_dict()
        # override the default output from pydantic by calling `to_dict()` of type
        if self.type:
            _dict['type'] = self.type.to_dict()
        # set to None if internal_id (nullable) is None
        # and model_fields_set contains the field
        if self.internal_id is None and "internal_id" in self.model_fields_set:
            _dict['internalId'] = None

        # set to None if interface_id (nullable) is None
        # and model_fields_set contains the field
        if self.interface_id is None and "interface_id" in self.model_fields_set:
            _dict['interfaceId'] = None

        # set to None if network_pool (nullable) is None
        # and model_fields_set contains the field
        if self.network_pool is None and "network_pool" in self.model_fields_set:
            _dict['networkPool'] = None

        # set to None if subnet (nullable) is None
        # and model_fields_set contains the field
        if self.subnet is None and "subnet" in self.model_fields_set:
            _dict['subnet'] = None

        # set to None if version (nullable) is None
        # and model_fields_set contains the field
        if self.version is None and "version" in self.model_fields_set:
            _dict['version'] = None

        # set to None if ip_subnet (nullable) is None
        # and model_fields_set contains the field
        if self.ip_subnet is None and "ip_subnet" in self.model_fields_set:
            _dict['ipSubnet'] = None

        # set to None if config (nullable) is None
        # and model_fields_set contains the field
        if self.config is None and "config" in self.model_fields_set:
            _dict['config'] = None

        # set to None if fabric_id (nullable) is None
        # and model_fields_set contains the field
        if self.fabric_id is None and "fabric_id" in self.model_fields_set:
            _dict['fabricId'] = None

        # set to None if ipv6_subnet (nullable) is None
        # and model_fields_set contains the field
        if self.ipv6_subnet is None and "ipv6_subnet" in self.model_fields_set:
            _dict['ipv6Subnet'] = None

        # set to None if public_ipv6_address (nullable) is None
        # and model_fields_set contains the field
        if self.public_ipv6_address is None and "public_ipv6_address" in self.model_fields_set:
            _dict['publicIpv6Address'] = None

        # set to None if ref_type (nullable) is None
        # and model_fields_set contains the field
        if self.ref_type is None and "ref_type" in self.model_fields_set:
            _dict['refType'] = None

        # set to None if network_group (nullable) is None
        # and model_fields_set contains the field
        if self.network_group is None and "network_group" in self.model_fields_set:
            _dict['networkGroup'] = None

        # set to None if ref_id (nullable) is None
        # and model_fields_set contains the field
        if self.ref_id is None and "ref_id" in self.model_fields_set:
            _dict['refId'] = None

        # set to None if network_domain (nullable) is None
        # and model_fields_set contains the field
        if self.network_domain is None and "network_domain" in self.model_fields_set:
            _dict['networkDomain'] = None

        # set to None if network_pool_ipv6 (nullable) is None
        # and model_fields_set contains the field
        if self.network_pool_ipv6 is None and "network_pool_ipv6" in self.model_fields_set:
            _dict['networkPoolIPv6'] = None

        # set to None if vlan_id (nullable) is None
        # and model_fields_set contains the field
        if self.vlan_id is None and "vlan_id" in self.model_fields_set:
            _dict['vlanId'] = None

        # set to None if network_position (nullable) is None
        # and model_fields_set contains the field
        if self.network_position is None and "network_position" in self.model_fields_set:
            _dict['networkPosition'] = None

        # set to None if external_type (nullable) is None
        # and model_fields_set contains the field
        if self.external_type is None and "external_type" in self.model_fields_set:
            _dict['externalType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateInstanceNetworkInterface200ResponseAllOfOneOfNetworkInterface from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "addresses": obj.get("addresses"),
            "internalId": obj.get("internalId"),
            "interfaceId": obj.get("interfaceId"),
            "displayOrder": obj.get("displayOrder"),
            "networkPool": obj.get("networkPool"),
            "dhcp": obj.get("dhcp"),
            "uuid": obj.get("uuid"),
            "active": obj.get("active"),
            "uniqueId": obj.get("uniqueId"),
            "subnet": obj.get("subnet"),
            "replaceHostRecord": obj.get("replaceHostRecord"),
            "ipMode": obj.get("ipMode"),
            "version": obj.get("version"),
            "ipSubnet": obj.get("ipSubnet"),
            "config": obj.get("config"),
            "publicIpAddress": obj.get("publicIpAddress"),
            "fabricId": obj.get("fabricId"),
            "ipv6Subnet": obj.get("ipv6Subnet"),
            "macAddress": obj.get("macAddress"),
            "publicIpv6Address": obj.get("publicIpv6Address"),
            "refType": obj.get("refType"),
            "networkGroup": obj.get("networkGroup"),
            "refId": obj.get("refId"),
            "networkDomain": obj.get("networkDomain"),
            "name": obj.get("name"),
            "primaryInterface": obj.get("primaryInterface"),
            "networkPoolIPv6": obj.get("networkPoolIPv6"),
            "network": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["network"]) if obj.get("network") is not None else None,
            "vlanId": obj.get("vlanId"),
            "type": GetAlerts200ResponseAllOfChecksInnerAccount.from_dict(obj["type"]) if obj.get("type") is not None else None,
            "networkPosition": obj.get("networkPosition"),
            "poolAssigned": obj.get("poolAssigned"),
            "description": obj.get("description"),
            "externalType": obj.get("externalType"),
            "externalId": obj.get("externalId")
        })
        return _obj


