# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZoneNetworkServerType(BaseModel):
    """
    UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZoneNetworkServerType
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    code: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    creatable: Optional[StrictBool] = None
    user_visible: Optional[StrictBool] = Field(default=None, alias="userVisible")
    has_scopes: Optional[StrictBool] = Field(default=None, alias="hasScopes")
    title_scopes: Optional[StrictStr] = Field(default=None, alias="titleScopes")
    has_networks: Optional[StrictBool] = Field(default=None, alias="hasNetworks")
    title_networks: Optional[StrictStr] = Field(default=None, alias="titleNetworks")
    has_switches: Optional[StrictBool] = Field(default=None, alias="hasSwitches")
    title_switches: Optional[StrictStr] = Field(default=None, alias="titleSwitches")
    has_gateways: Optional[StrictBool] = Field(default=None, alias="hasGateways")
    title_gateways: Optional[StrictStr] = Field(default=None, alias="titleGateways")
    has_routers: Optional[StrictBool] = Field(default=None, alias="hasRouters")
    title_routers: Optional[StrictStr] = Field(default=None, alias="titleRouters")
    has_security_groups: Optional[StrictBool] = Field(default=None, alias="hasSecurityGroups")
    title_security_groups: Optional[StrictStr] = Field(default=None, alias="titleSecurityGroups")
    has_load_balancers: Optional[StrictBool] = Field(default=None, alias="hasLoadBalancers")
    title_load_balancers: Optional[StrictStr] = Field(default=None, alias="titleLoadBalancers")
    has_route_tables: Optional[StrictBool] = Field(default=None, alias="hasRouteTables")
    title_route_tables: Optional[StrictStr] = Field(default=None, alias="titleRouteTables")
    has_firewall: Optional[StrictBool] = Field(default=None, alias="hasFirewall")
    title_firewall: Optional[StrictStr] = Field(default=None, alias="titleFirewall")
    has_firewall_groups: Optional[StrictBool] = Field(default=None, alias="hasFirewallGroups")
    title_firewall_groups: Optional[StrictStr] = Field(default=None, alias="titleFirewallGroups")
    __properties: ClassVar[List[str]] = ["id", "name", "code", "description", "creatable", "userVisible", "hasScopes", "titleScopes", "hasNetworks", "titleNetworks", "hasSwitches", "titleSwitches", "hasGateways", "titleGateways", "hasRouters", "titleRouters", "hasSecurityGroups", "titleSecurityGroups", "hasLoadBalancers", "titleLoadBalancers", "hasRouteTables", "titleRouteTables", "hasFirewall", "titleFirewall", "hasFirewallGroups", "titleFirewallGroups"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZoneNetworkServerType from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if title_scopes (nullable) is None
        # and model_fields_set contains the field
        if self.title_scopes is None and "title_scopes" in self.model_fields_set:
            _dict['titleScopes'] = None

        # set to None if title_networks (nullable) is None
        # and model_fields_set contains the field
        if self.title_networks is None and "title_networks" in self.model_fields_set:
            _dict['titleNetworks'] = None

        # set to None if title_switches (nullable) is None
        # and model_fields_set contains the field
        if self.title_switches is None and "title_switches" in self.model_fields_set:
            _dict['titleSwitches'] = None

        # set to None if title_gateways (nullable) is None
        # and model_fields_set contains the field
        if self.title_gateways is None and "title_gateways" in self.model_fields_set:
            _dict['titleGateways'] = None

        # set to None if title_routers (nullable) is None
        # and model_fields_set contains the field
        if self.title_routers is None and "title_routers" in self.model_fields_set:
            _dict['titleRouters'] = None

        # set to None if title_security_groups (nullable) is None
        # and model_fields_set contains the field
        if self.title_security_groups is None and "title_security_groups" in self.model_fields_set:
            _dict['titleSecurityGroups'] = None

        # set to None if title_load_balancers (nullable) is None
        # and model_fields_set contains the field
        if self.title_load_balancers is None and "title_load_balancers" in self.model_fields_set:
            _dict['titleLoadBalancers'] = None

        # set to None if title_route_tables (nullable) is None
        # and model_fields_set contains the field
        if self.title_route_tables is None and "title_route_tables" in self.model_fields_set:
            _dict['titleRouteTables'] = None

        # set to None if title_firewall (nullable) is None
        # and model_fields_set contains the field
        if self.title_firewall is None and "title_firewall" in self.model_fields_set:
            _dict['titleFirewall'] = None

        # set to None if title_firewall_groups (nullable) is None
        # and model_fields_set contains the field
        if self.title_firewall_groups is None and "title_firewall_groups" in self.model_fields_set:
            _dict['titleFirewallGroups'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateInstanceNetworkInterface200ResponseAllOfOneOfServerZoneNetworkServerType from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "code": obj.get("code"),
            "description": obj.get("description"),
            "creatable": obj.get("creatable"),
            "userVisible": obj.get("userVisible"),
            "hasScopes": obj.get("hasScopes"),
            "titleScopes": obj.get("titleScopes"),
            "hasNetworks": obj.get("hasNetworks"),
            "titleNetworks": obj.get("titleNetworks"),
            "hasSwitches": obj.get("hasSwitches"),
            "titleSwitches": obj.get("titleSwitches"),
            "hasGateways": obj.get("hasGateways"),
            "titleGateways": obj.get("titleGateways"),
            "hasRouters": obj.get("hasRouters"),
            "titleRouters": obj.get("titleRouters"),
            "hasSecurityGroups": obj.get("hasSecurityGroups"),
            "titleSecurityGroups": obj.get("titleSecurityGroups"),
            "hasLoadBalancers": obj.get("hasLoadBalancers"),
            "titleLoadBalancers": obj.get("titleLoadBalancers"),
            "hasRouteTables": obj.get("hasRouteTables"),
            "titleRouteTables": obj.get("titleRouteTables"),
            "hasFirewall": obj.get("hasFirewall"),
            "titleFirewall": obj.get("titleFirewall"),
            "hasFirewallGroups": obj.get("hasFirewallGroups"),
            "titleFirewallGroups": obj.get("titleFirewallGroups")
        })
        return _obj


