# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class UpdateInstanceScheduleRequestInstanceScheduleThreshold(BaseModel):
    """
    UpdateInstanceScheduleRequestInstanceScheduleThreshold
    """ # noqa: E501
    source_threshold_id: Optional[StrictInt] = Field(default=None, description="Source Scale Threshold to apply as a template. All threshold settings with be copied from this threshold, and can be overridden by also passing each setting explicitly.", alias="sourceThresholdId")
    auto_up: Optional[StrictBool] = Field(default=None, description="Auto Upscale", alias="autoUp")
    auto_down: Optional[StrictBool] = Field(default=None, description="Auto Downscale", alias="autoDown")
    min_count: Optional[StrictInt] = Field(default=None, description="The minimum number of nodes to scale down to", alias="minCount")
    max_count: Optional[StrictInt] = Field(default=None, description="The maximum number of nodes to scale up to", alias="maxCount")
    cpu_enabled: Optional[StrictBool] = Field(default=None, description="Enable CPU Threshold", alias="cpuEnabled")
    min_cpu: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Min CPU (%)", alias="minCpu")
    max_cpu: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Max CPU (%)", alias="maxCpu")
    memory_enabled: Optional[StrictBool] = Field(default=None, description="Enable Memory Threshold", alias="memoryEnabled")
    min_memory: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Min Memory (%)", alias="minMemory")
    max_memory: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Max Memory (%)", alias="maxMemory")
    disk_enabled: Optional[StrictBool] = Field(default=None, description="Enable Disk Threshold", alias="diskEnabled")
    min_disk: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Min Disk (%)", alias="minDisk")
    max_disk: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Max Disk (%)", alias="maxDisk")
    __properties: ClassVar[List[str]] = ["sourceThresholdId", "autoUp", "autoDown", "minCount", "maxCount", "cpuEnabled", "minCpu", "maxCpu", "memoryEnabled", "minMemory", "maxMemory", "diskEnabled", "minDisk", "maxDisk"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateInstanceScheduleRequestInstanceScheduleThreshold from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateInstanceScheduleRequestInstanceScheduleThreshold from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sourceThresholdId": obj.get("sourceThresholdId"),
            "autoUp": obj.get("autoUp"),
            "autoDown": obj.get("autoDown"),
            "minCount": obj.get("minCount"),
            "maxCount": obj.get("maxCount"),
            "cpuEnabled": obj.get("cpuEnabled"),
            "minCpu": obj.get("minCpu"),
            "maxCpu": obj.get("maxCpu"),
            "memoryEnabled": obj.get("memoryEnabled"),
            "minMemory": obj.get("minMemory"),
            "maxMemory": obj.get("maxMemory"),
            "diskEnabled": obj.get("diskEnabled"),
            "minDisk": obj.get("minDisk"),
            "maxDisk": obj.get("maxDisk")
        })
        return _obj


