# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.workflow_job_payload_schedule_mode import WorkflowJobPayloadScheduleMode
from morpheus.models.workflow_job_payload_targets_inner import WorkflowJobPayloadTargetsInner
from morpheus.models.workflow_job_payload_task import WorkflowJobPayloadTask
from typing import Optional, Set
from typing_extensions import Self

class UpdateJobsRequestJob(BaseModel):
    """
    UpdateJobsRequestJob
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="A name for the Job")
    labels: Optional[List[StrictStr]] = Field(default=None, description="Array of label strings, can be used for filtering.")
    enabled: Optional[StrictBool] = Field(default=True, description="Use this to set enabled state")
    task: Optional[WorkflowJobPayloadTask] = None
    workflow: Optional[WorkflowJobPayloadTask] = None
    scan_path: Optional[StrictStr] = Field(default=None, description="Scan Checklist. Only applies to type scap-package.", alias="scanPath")
    security_profile: Optional[StrictStr] = Field(default=None, description="Security Profile. Only applies to type scap-package.", alias="securityProfile")
    target_type: Optional[StrictStr] = Field(default=None, description="Target type where job will execute", alias="targetType")
    targets: Optional[List[WorkflowJobPayloadTargetsInner]] = None
    instance_label: Optional[StrictStr] = Field(default=None, description="Instance Label. Only applicable if `targetType` is `instance-label`.", alias="instanceLabel")
    server_label: Optional[StrictStr] = Field(default=None, description="Server Label. Only applicable if `targetType` is `server-label`.", alias="serverLabel")
    schedule_mode: Optional[WorkflowJobPayloadScheduleMode] = Field(default=None, alias="scheduleMode")
    custom_options: Optional[Dict[str, Any]] = Field(default=None, description="Map of options to be used as values in the workflow tasks. These correspond to option types.", alias="customOptions")
    custom_config: Optional[StrictStr] = Field(default=None, description="Job custom configuration (String in JSON format)", alias="customConfig")
    date_time: Optional[datetime] = Field(default=None, description="Date and Time to execute the job. Use UTC time in the format 2020-02-15T05:00:00Z. Required when scheduleMode is 'dateTime'.", alias="dateTime")
    run: Optional[StrictBool] = Field(default=None, description="If true, executes job")
    __properties: ClassVar[List[str]] = ["name", "labels", "enabled", "task", "workflow", "scanPath", "securityProfile", "targetType", "targets", "instanceLabel", "serverLabel", "scheduleMode", "customOptions", "customConfig", "dateTime", "run"]

    @field_validator('target_type')
    def target_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['appliance', 'instance', 'instance-label', 'server', 'server-label']):
            raise ValueError("must be one of enum values ('appliance', 'instance', 'instance-label', 'server', 'server-label')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateJobsRequestJob from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of task
        if self.task:
            _dict['task'] = self.task.to_dict()
        # override the default output from pydantic by calling `to_dict()` of workflow
        if self.workflow:
            _dict['workflow'] = self.workflow.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in targets (list)
        _items = []
        if self.targets:
            for _item_targets in self.targets:
                if _item_targets:
                    _items.append(_item_targets.to_dict())
            _dict['targets'] = _items
        # override the default output from pydantic by calling `to_dict()` of schedule_mode
        if self.schedule_mode:
            _dict['scheduleMode'] = self.schedule_mode.to_dict()
        # set to None if labels (nullable) is None
        # and model_fields_set contains the field
        if self.labels is None and "labels" in self.model_fields_set:
            _dict['labels'] = None

        # set to None if scan_path (nullable) is None
        # and model_fields_set contains the field
        if self.scan_path is None and "scan_path" in self.model_fields_set:
            _dict['scanPath'] = None

        # set to None if security_profile (nullable) is None
        # and model_fields_set contains the field
        if self.security_profile is None and "security_profile" in self.model_fields_set:
            _dict['securityProfile'] = None

        # set to None if targets (nullable) is None
        # and model_fields_set contains the field
        if self.targets is None and "targets" in self.model_fields_set:
            _dict['targets'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateJobsRequestJob from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "labels": obj.get("labels"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "task": WorkflowJobPayloadTask.from_dict(obj["task"]) if obj.get("task") is not None else None,
            "workflow": WorkflowJobPayloadTask.from_dict(obj["workflow"]) if obj.get("workflow") is not None else None,
            "scanPath": obj.get("scanPath"),
            "securityProfile": obj.get("securityProfile"),
            "targetType": obj.get("targetType"),
            "targets": [WorkflowJobPayloadTargetsInner.from_dict(_item) for _item in obj["targets"]] if obj.get("targets") is not None else None,
            "instanceLabel": obj.get("instanceLabel"),
            "serverLabel": obj.get("serverLabel"),
            "scheduleMode": WorkflowJobPayloadScheduleMode.from_dict(obj["scheduleMode"]) if obj.get("scheduleMode") is not None else None,
            "customOptions": obj.get("customOptions"),
            "customConfig": obj.get("customConfig"),
            "dateTime": obj.get("dateTime"),
            "run": obj.get("run")
        })
        return _obj


