# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.get_alerts200_response_all_of_check_groups_inner_instance import GetAlerts200ResponseAllOfCheckGroupsInnerInstance
from morpheus.models.list_cloud_datastores200_response_all_of_datastores_inner_resource_permission import ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission
from morpheus.models.list_cloud_datastores200_response_all_of_datastores_inner_tenants_inner import ListCloudDatastores200ResponseAllOfDatastoresInnerTenantsInner
from typing import Optional, Set
from typing_extensions import Self

class ZoneDatastore(BaseModel):
    """
    ZoneDatastore
    """ # noqa: E501
    id: Optional[StrictInt] = None
    name: Optional[StrictStr] = None
    zone: Optional[GetAlerts200ResponseAllOfCheckGroupsInnerInstance] = None
    type: Optional[StrictStr] = None
    free_space: Optional[StrictInt] = Field(default=None, alias="freeSpace")
    online: Optional[StrictBool] = None
    active: Optional[StrictBool] = None
    visibility: Optional[StrictStr] = None
    tenants: Optional[List[ListCloudDatastores200ResponseAllOfDatastoresInnerTenantsInner]] = None
    resource_permission: Optional[ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission] = Field(default=None, alias="resourcePermission")
    __properties: ClassVar[List[str]] = ["id", "name", "zone", "type", "freeSpace", "online", "active", "visibility", "tenants", "resourcePermission"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ZoneDatastore from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of zone
        if self.zone:
            _dict['zone'] = self.zone.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in tenants (list)
        _items = []
        if self.tenants:
            for _item_tenants in self.tenants:
                if _item_tenants:
                    _items.append(_item_tenants.to_dict())
            _dict['tenants'] = _items
        # override the default output from pydantic by calling `to_dict()` of resource_permission
        if self.resource_permission:
            _dict['resourcePermission'] = self.resource_permission.to_dict()
        # set to None if tenants (nullable) is None
        # and model_fields_set contains the field
        if self.tenants is None and "tenants" in self.model_fields_set:
            _dict['tenants'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ZoneDatastore from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "zone": GetAlerts200ResponseAllOfCheckGroupsInnerInstance.from_dict(obj["zone"]) if obj.get("zone") is not None else None,
            "type": obj.get("type"),
            "freeSpace": obj.get("freeSpace"),
            "online": obj.get("online"),
            "active": obj.get("active"),
            "visibility": obj.get("visibility"),
            "tenants": [ListCloudDatastores200ResponseAllOfDatastoresInnerTenantsInner.from_dict(_item) for _item in obj["tenants"]] if obj.get("tenants") is not None else None,
            "resourcePermission": ListCloudDatastores200ResponseAllOfDatastoresInnerResourcePermission.from_dict(obj["resourcePermission"]) if obj.get("resourcePermission") is not None else None
        })
        return _obj


