# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.list_clouds200_response_all_of_zones_inner_config_any_of_network_server import ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer
from typing import Optional, Set
from typing_extensions import Self

class ZoneGcpConfig(BaseModel):
    """
    ZoneGcpConfig
    """ # noqa: E501
    private_key: Optional[StrictStr] = Field(default=None, alias="privateKey")
    client_email: Optional[StrictStr] = Field(default=None, alias="clientEmail")
    project_id: Optional[StrictStr] = Field(default=None, alias="projectId")
    google_region_id: Optional[StrictStr] = Field(default=None, alias="googleRegionId")
    import_existing: Optional[StrictStr] = Field(default=None, alias="importExisting")
    appliance_url: Optional[StrictStr] = Field(default=None, alias="applianceUrl")
    datacenter_name: Optional[StrictStr] = Field(default=None, alias="datacenterName")
    network_server_id: Optional[StrictStr] = Field(default=None, alias="networkServer.id")
    network_server: Optional[ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer] = Field(default=None, alias="networkServer")
    security_server: Optional[StrictStr] = Field(default=None, alias="securityServer")
    certificate_provider: Optional[StrictStr] = Field(default=None, alias="certificateProvider")
    backup_mode: Optional[StrictStr] = Field(default=None, alias="backupMode")
    replication_mode: Optional[StrictStr] = Field(default=None, alias="replicationMode")
    dns_integration_id: Optional[StrictStr] = Field(default=None, alias="dnsIntegrationId")
    service_registry_id: Optional[StrictStr] = Field(default=None, alias="serviceRegistryId")
    config_management_id: Optional[StrictStr] = Field(default=None, alias="configManagementId")
    private_key_hash: Optional[StrictStr] = Field(default=None, alias="privateKeyHash")
    __properties: ClassVar[List[str]] = ["privateKey", "clientEmail", "projectId", "googleRegionId", "importExisting", "applianceUrl", "datacenterName", "networkServer.id", "networkServer", "securityServer", "certificateProvider", "backupMode", "replicationMode", "dnsIntegrationId", "serviceRegistryId", "configManagementId", "privateKeyHash"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ZoneGcpConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of network_server
        if self.network_server:
            _dict['networkServer'] = self.network_server.to_dict()
        # set to None if security_server (nullable) is None
        # and model_fields_set contains the field
        if self.security_server is None and "security_server" in self.model_fields_set:
            _dict['securityServer'] = None

        # set to None if certificate_provider (nullable) is None
        # and model_fields_set contains the field
        if self.certificate_provider is None and "certificate_provider" in self.model_fields_set:
            _dict['certificateProvider'] = None

        # set to None if backup_mode (nullable) is None
        # and model_fields_set contains the field
        if self.backup_mode is None and "backup_mode" in self.model_fields_set:
            _dict['backupMode'] = None

        # set to None if replication_mode (nullable) is None
        # and model_fields_set contains the field
        if self.replication_mode is None and "replication_mode" in self.model_fields_set:
            _dict['replicationMode'] = None

        # set to None if dns_integration_id (nullable) is None
        # and model_fields_set contains the field
        if self.dns_integration_id is None and "dns_integration_id" in self.model_fields_set:
            _dict['dnsIntegrationId'] = None

        # set to None if service_registry_id (nullable) is None
        # and model_fields_set contains the field
        if self.service_registry_id is None and "service_registry_id" in self.model_fields_set:
            _dict['serviceRegistryId'] = None

        # set to None if config_management_id (nullable) is None
        # and model_fields_set contains the field
        if self.config_management_id is None and "config_management_id" in self.model_fields_set:
            _dict['configManagementId'] = None

        # set to None if private_key_hash (nullable) is None
        # and model_fields_set contains the field
        if self.private_key_hash is None and "private_key_hash" in self.model_fields_set:
            _dict['privateKeyHash'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ZoneGcpConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "privateKey": obj.get("privateKey"),
            "clientEmail": obj.get("clientEmail"),
            "projectId": obj.get("projectId"),
            "googleRegionId": obj.get("googleRegionId"),
            "importExisting": obj.get("importExisting"),
            "applianceUrl": obj.get("applianceUrl"),
            "datacenterName": obj.get("datacenterName"),
            "networkServer.id": obj.get("networkServer.id"),
            "networkServer": ListClouds200ResponseAllOfZonesInnerConfigAnyOfNetworkServer.from_dict(obj["networkServer"]) if obj.get("networkServer") is not None else None,
            "securityServer": obj.get("securityServer"),
            "certificateProvider": obj.get("certificateProvider"),
            "backupMode": obj.get("backupMode"),
            "replicationMode": obj.get("replicationMode"),
            "dnsIntegrationId": obj.get("dnsIntegrationId"),
            "serviceRegistryId": obj.get("serviceRegistryId"),
            "configManagementId": obj.get("configManagementId"),
            "privateKeyHash": obj.get("privateKeyHash")
        })
        return _obj


