# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from morpheus.models.get_billing_instances_identifier200_response import GetBillingInstancesIdentifier200Response
from morpheus.models.get_billing_servers_identifier200_response import GetBillingServersIdentifier200Response
from morpheus.models.get_billing_zone_identifier200_response import GetBillingZoneIdentifier200Response
from morpheus.models.list_billing_account200_response import ListBillingAccount200Response
from morpheus.models.list_billing_instances200_response import ListBillingInstances200Response
from morpheus.models.list_billing_servers200_response import ListBillingServers200Response
from morpheus.models.list_billing_zone200_response import ListBillingZone200Response

from morpheus.api_client import ApiClient, RequestSerialized
from morpheus.api_response import ApiResponse
from morpheus.rest import RESTResponseType


class BillingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_billing_account(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListBillingAccount200Response:
        """This endpoint will retrieve a specific account by id if the user has permission to access it

        Will retrieve billing information for a specific tenant, if it is the current account or a sub account of the requesting user's account. 

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_account_serialize(
            id=id,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingAccount200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_billing_account_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListBillingAccount200Response]:
        """This endpoint will retrieve a specific account by id if the user has permission to access it

        Will retrieve billing information for a specific tenant, if it is the current account or a sub account of the requesting user's account. 

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_account_serialize(
            id=id,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingAccount200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_billing_account_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="Morpheus ID of the Object being referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """This endpoint will retrieve a specific account by id if the user has permission to access it

        Will retrieve billing information for a specific tenant, if it is the current account or a sub account of the requesting user's account. 

        :param id: Morpheus ID of the Object being referenced (required)
        :type id: int
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_account_serialize(
            id=id,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingAccount200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_billing_account_serialize(
        self,
        id,
        start_date,
        end_date,
        include_usages,
        max_usages,
        offset_usages,
        include_compute_servers,
        include_instances,
        include_discovered_servers,
        include_load_balancers,
        include_virtual_images,
        include_snapshots,
        include_ms,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if include_usages is not None:
            
            _query_params.append(('includeUsages', include_usages))
            
        if max_usages is not None:
            
            _query_params.append(('maxUsages', max_usages))
            
        if offset_usages is not None:
            
            _query_params.append(('offsetUsages', offset_usages))
            
        if include_compute_servers is not None:
            
            _query_params.append(('includeComputeServers', include_compute_servers))
            
        if include_instances is not None:
            
            _query_params.append(('includeInstances', include_instances))
            
        if include_discovered_servers is not None:
            
            _query_params.append(('includeDiscoveredServers', include_discovered_servers))
            
        if include_load_balancers is not None:
            
            _query_params.append(('includeLoadBalancers', include_load_balancers))
            
        if include_virtual_images is not None:
            
            _query_params.append(('includeVirtualImages', include_virtual_images))
            
        if include_snapshots is not None:
            
            _query_params.append(('includeSnapshots', include_snapshots))
            
        if include_ms is not None:
            
            _query_params.append(('includeMs', include_ms))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/billing/account/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_billing_instances_identifier(
        self,
        identifier: Annotated[StrictStr, Field(description="Morpheus UUID or ID of the Object being created or referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetBillingInstancesIdentifier200Response:
        """Retrieves billing information for an instance in the requestor's account. Use instanceUUID whenever possible.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param identifier: Morpheus UUID or ID of the Object being created or referenced (required)
        :type identifier: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_instances_identifier_serialize(
            identifier=identifier,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingInstancesIdentifier200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_billing_instances_identifier_with_http_info(
        self,
        identifier: Annotated[StrictStr, Field(description="Morpheus UUID or ID of the Object being created or referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetBillingInstancesIdentifier200Response]:
        """Retrieves billing information for an instance in the requestor's account. Use instanceUUID whenever possible.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param identifier: Morpheus UUID or ID of the Object being created or referenced (required)
        :type identifier: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_instances_identifier_serialize(
            identifier=identifier,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingInstancesIdentifier200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_billing_instances_identifier_without_preload_content(
        self,
        identifier: Annotated[StrictStr, Field(description="Morpheus UUID or ID of the Object being created or referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves billing information for an instance in the requestor's account. Use instanceUUID whenever possible.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param identifier: Morpheus UUID or ID of the Object being created or referenced (required)
        :type identifier: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_instances_identifier_serialize(
            identifier=identifier,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingInstancesIdentifier200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_billing_instances_identifier_serialize(
        self,
        identifier,
        start_date,
        end_date,
        include_usages,
        max_usages,
        offset_usages,
        include_tenants,
        account_id,
        include_ms,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if identifier is not None:
            _path_params['identifier'] = identifier
        # process the query parameters
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if include_usages is not None:
            
            _query_params.append(('includeUsages', include_usages))
            
        if max_usages is not None:
            
            _query_params.append(('maxUsages', max_usages))
            
        if offset_usages is not None:
            
            _query_params.append(('offsetUsages', offset_usages))
            
        if include_tenants is not None:
            
            _query_params.append(('includeTenants', include_tenants))
            
        if account_id is not None:
            
            _query_params.append(('accountId', account_id))
            
        if include_ms is not None:
            
            _query_params.append(('includeMs', include_ms))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/billing/instances/{identifier}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_billing_servers_identifier(
        self,
        identifier: Annotated[StrictStr, Field(description="Morpheus UUID or ID of the Object being created or referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetBillingServersIdentifier200Response:
        """Retrieves billing information for a specific server (container host) in the requestor's account. Use refUUID whenever possible.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param identifier: Morpheus UUID or ID of the Object being created or referenced (required)
        :type identifier: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_servers_identifier_serialize(
            identifier=identifier,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingServersIdentifier200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_billing_servers_identifier_with_http_info(
        self,
        identifier: Annotated[StrictStr, Field(description="Morpheus UUID or ID of the Object being created or referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetBillingServersIdentifier200Response]:
        """Retrieves billing information for a specific server (container host) in the requestor's account. Use refUUID whenever possible.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param identifier: Morpheus UUID or ID of the Object being created or referenced (required)
        :type identifier: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_servers_identifier_serialize(
            identifier=identifier,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingServersIdentifier200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_billing_servers_identifier_without_preload_content(
        self,
        identifier: Annotated[StrictStr, Field(description="Morpheus UUID or ID of the Object being created or referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves billing information for a specific server (container host) in the requestor's account. Use refUUID whenever possible.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param identifier: Morpheus UUID or ID of the Object being created or referenced (required)
        :type identifier: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_servers_identifier_serialize(
            identifier=identifier,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingServersIdentifier200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_billing_servers_identifier_serialize(
        self,
        identifier,
        start_date,
        end_date,
        include_usages,
        max_usages,
        offset_usages,
        include_tenants,
        account_id,
        include_ms,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if identifier is not None:
            _path_params['identifier'] = identifier
        # process the query parameters
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if include_usages is not None:
            
            _query_params.append(('includeUsages', include_usages))
            
        if max_usages is not None:
            
            _query_params.append(('maxUsages', max_usages))
            
        if offset_usages is not None:
            
            _query_params.append(('offsetUsages', offset_usages))
            
        if include_tenants is not None:
            
            _query_params.append(('includeTenants', include_tenants))
            
        if account_id is not None:
            
            _query_params.append(('accountId', account_id))
            
        if include_ms is not None:
            
            _query_params.append(('includeMs', include_ms))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/billing/servers/{identifier}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_billing_zone_identifier(
        self,
        identifier: Annotated[StrictStr, Field(description="Morpheus UUID or ID of the Object being created or referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetBillingZoneIdentifier200Response:
        """Retrieves billing information for a specific zone in the requestor's account. Use zoneUUID whenever possible.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param identifier: Morpheus UUID or ID of the Object being created or referenced (required)
        :type identifier: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_zone_identifier_serialize(
            identifier=identifier,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingZoneIdentifier200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_billing_zone_identifier_with_http_info(
        self,
        identifier: Annotated[StrictStr, Field(description="Morpheus UUID or ID of the Object being created or referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetBillingZoneIdentifier200Response]:
        """Retrieves billing information for a specific zone in the requestor's account. Use zoneUUID whenever possible.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param identifier: Morpheus UUID or ID of the Object being created or referenced (required)
        :type identifier: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_zone_identifier_serialize(
            identifier=identifier,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingZoneIdentifier200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_billing_zone_identifier_without_preload_content(
        self,
        identifier: Annotated[StrictStr, Field(description="Morpheus UUID or ID of the Object being created or referenced")],
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves billing information for a specific zone in the requestor's account. Use zoneUUID whenever possible.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param identifier: Morpheus UUID or ID of the Object being created or referenced (required)
        :type identifier: str
        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_billing_zone_identifier_serialize(
            identifier=identifier,
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetBillingZoneIdentifier200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_billing_zone_identifier_serialize(
        self,
        identifier,
        start_date,
        end_date,
        include_usages,
        max_usages,
        offset_usages,
        include_compute_servers,
        include_instances,
        include_discovered_servers,
        include_load_balancers,
        include_virtual_images,
        include_snapshots,
        include_ms,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if identifier is not None:
            _path_params['identifier'] = identifier
        # process the query parameters
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if include_usages is not None:
            
            _query_params.append(('includeUsages', include_usages))
            
        if max_usages is not None:
            
            _query_params.append(('maxUsages', max_usages))
            
        if offset_usages is not None:
            
            _query_params.append(('offsetUsages', offset_usages))
            
        if include_compute_servers is not None:
            
            _query_params.append(('includeComputeServers', include_compute_servers))
            
        if include_instances is not None:
            
            _query_params.append(('includeInstances', include_instances))
            
        if include_discovered_servers is not None:
            
            _query_params.append(('includeDiscoveredServers', include_discovered_servers))
            
        if include_load_balancers is not None:
            
            _query_params.append(('includeLoadBalancers', include_load_balancers))
            
        if include_virtual_images is not None:
            
            _query_params.append(('includeVirtualImages', include_virtual_images))
            
        if include_snapshots is not None:
            
            _query_params.append(('includeSnapshots', include_snapshots))
            
        if include_ms is not None:
            
            _query_params.append(('includeMs', include_ms))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/billing/zones/{identifier}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_billing_account(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListBillingAccount200Response:
        """Retrieves billing information for the requesting user's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_account_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingAccount200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_billing_account_with_http_info(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListBillingAccount200Response]:
        """Retrieves billing information for the requesting user's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_account_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingAccount200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_billing_account_without_preload_content(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves billing information for the requesting user's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_account_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingAccount200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_billing_account_serialize(
        self,
        start_date,
        end_date,
        include_usages,
        max_usages,
        offset_usages,
        include_compute_servers,
        include_instances,
        include_discovered_servers,
        include_load_balancers,
        include_virtual_images,
        include_snapshots,
        include_ms,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if include_usages is not None:
            
            _query_params.append(('includeUsages', include_usages))
            
        if max_usages is not None:
            
            _query_params.append(('maxUsages', max_usages))
            
        if offset_usages is not None:
            
            _query_params.append(('offsetUsages', offset_usages))
            
        if include_compute_servers is not None:
            
            _query_params.append(('includeComputeServers', include_compute_servers))
            
        if include_instances is not None:
            
            _query_params.append(('includeInstances', include_instances))
            
        if include_discovered_servers is not None:
            
            _query_params.append(('includeDiscoveredServers', include_discovered_servers))
            
        if include_load_balancers is not None:
            
            _query_params.append(('includeLoadBalancers', include_load_balancers))
            
        if include_virtual_images is not None:
            
            _query_params.append(('includeVirtualImages', include_virtual_images))
            
        if include_snapshots is not None:
            
            _query_params.append(('includeSnapshots', include_snapshots))
            
        if include_ms is not None:
            
            _query_params.append(('includeMs', include_ms))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/billing/account',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_billing_instances(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListBillingInstances200Response:
        """Retrieves billing information for all instances on the requestor's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_instances_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingInstances200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_billing_instances_with_http_info(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListBillingInstances200Response]:
        """Retrieves billing information for all instances on the requestor's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_instances_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingInstances200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_billing_instances_without_preload_content(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves billing information for all instances on the requestor's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_instances_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingInstances200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_billing_instances_serialize(
        self,
        start_date,
        end_date,
        include_usages,
        max_usages,
        offset_usages,
        include_tenants,
        account_id,
        include_ms,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if include_usages is not None:
            
            _query_params.append(('includeUsages', include_usages))
            
        if max_usages is not None:
            
            _query_params.append(('maxUsages', max_usages))
            
        if offset_usages is not None:
            
            _query_params.append(('offsetUsages', offset_usages))
            
        if include_tenants is not None:
            
            _query_params.append(('includeTenants', include_tenants))
            
        if account_id is not None:
            
            _query_params.append(('accountId', account_id))
            
        if include_ms is not None:
            
            _query_params.append(('includeMs', include_ms))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/billing/instances',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_billing_servers(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListBillingServers200Response:
        """Retrieves billing information for all servers (container hosts) on the requestor's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_servers_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingServers200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_billing_servers_with_http_info(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListBillingServers200Response]:
        """Retrieves billing information for all servers (container hosts) on the requestor's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_servers_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingServers200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_billing_servers_without_preload_content(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_tenants: Annotated[Optional[StrictBool], Field(description="Optional ability to include all subtenant billing information when calling from a master tenant user")] = None,
        account_id: Annotated[Optional[StrictInt], Field(description="Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves billing information for all servers (container hosts) on the requestor's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_tenants: Optional ability to include all subtenant billing information when calling from a master tenant user
        :type include_tenants: bool
        :param account_id: Filter by Tenant ID. This is only available to master tenant users with permission to manage tenants and users.
        :type account_id: int
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_servers_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_tenants=include_tenants,
            account_id=account_id,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingServers200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_billing_servers_serialize(
        self,
        start_date,
        end_date,
        include_usages,
        max_usages,
        offset_usages,
        include_tenants,
        account_id,
        include_ms,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if include_usages is not None:
            
            _query_params.append(('includeUsages', include_usages))
            
        if max_usages is not None:
            
            _query_params.append(('maxUsages', max_usages))
            
        if offset_usages is not None:
            
            _query_params.append(('offsetUsages', offset_usages))
            
        if include_tenants is not None:
            
            _query_params.append(('includeTenants', include_tenants))
            
        if account_id is not None:
            
            _query_params.append(('accountId', account_id))
            
        if include_ms is not None:
            
            _query_params.append(('includeMs', include_ms))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/billing/servers',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_billing_zone(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListBillingZone200Response:
        """Retrieves billing information for all zones on the requestor's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_zone_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingZone200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_billing_zone_with_http_info(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListBillingZone200Response]:
        """Retrieves billing information for all zones on the requestor's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_zone_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingZone200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_billing_zone_without_preload_content(
        self,
        start_date: Annotated[Optional[StrictStr], Field(description="Filter by startDate greater than or equal to a specified date")] = None,
        end_date: Annotated[Optional[StrictStr], Field(description="Filter by endDate less than or equal to a specified date")] = None,
        include_usages: Annotated[Optional[StrictBool], Field(description="Optional ability to suppress the usage records")] = None,
        max_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to limit the usages returned")] = None,
        offset_usages: Annotated[Optional[StrictInt], Field(description="Optional ability to offset the usages returned, for use with maxUsages to paginate")] = None,
        include_compute_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude compute servers")] = None,
        include_instances: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude instances")] = None,
        include_discovered_servers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude discovered servers")] = None,
        include_load_balancers: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude load balancers")] = None,
        include_virtual_images: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude virtual images")] = None,
        include_snapshots: Annotated[Optional[StrictBool], Field(description="Optional ability to exclude snapshots")] = None,
        include_ms: Annotated[Optional[StrictBool], Field(description="Optional ability to include milliseconds")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves billing information for all zones on the requestor's account.

        Provides API interfaces for viewing billing usage information by tenant, zone, instance or server. By default, usage returned is from the beginning of the current month until now. The date range is parameterized but the end date cannot exceed the current date. 

        :param start_date: Filter by startDate greater than or equal to a specified date
        :type start_date: str
        :param end_date: Filter by endDate less than or equal to a specified date
        :type end_date: str
        :param include_usages: Optional ability to suppress the usage records
        :type include_usages: bool
        :param max_usages: Optional ability to limit the usages returned
        :type max_usages: int
        :param offset_usages: Optional ability to offset the usages returned, for use with maxUsages to paginate
        :type offset_usages: int
        :param include_compute_servers: Optional ability to exclude compute servers
        :type include_compute_servers: bool
        :param include_instances: Optional ability to exclude instances
        :type include_instances: bool
        :param include_discovered_servers: Optional ability to exclude discovered servers
        :type include_discovered_servers: bool
        :param include_load_balancers: Optional ability to exclude load balancers
        :type include_load_balancers: bool
        :param include_virtual_images: Optional ability to exclude virtual images
        :type include_virtual_images: bool
        :param include_snapshots: Optional ability to exclude snapshots
        :type include_snapshots: bool
        :param include_ms: Optional ability to include milliseconds
        :type include_ms: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_billing_zone_serialize(
            start_date=start_date,
            end_date=end_date,
            include_usages=include_usages,
            max_usages=max_usages,
            offset_usages=offset_usages,
            include_compute_servers=include_compute_servers,
            include_instances=include_instances,
            include_discovered_servers=include_discovered_servers,
            include_load_balancers=include_load_balancers,
            include_virtual_images=include_virtual_images,
            include_snapshots=include_snapshots,
            include_ms=include_ms,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListBillingZone200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_billing_zone_serialize(
        self,
        start_date,
        end_date,
        include_usages,
        max_usages,
        offset_usages,
        include_compute_servers,
        include_instances,
        include_discovered_servers,
        include_load_balancers,
        include_virtual_images,
        include_snapshots,
        include_ms,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if start_date is not None:
            
            _query_params.append(('startDate', start_date))
            
        if end_date is not None:
            
            _query_params.append(('endDate', end_date))
            
        if include_usages is not None:
            
            _query_params.append(('includeUsages', include_usages))
            
        if max_usages is not None:
            
            _query_params.append(('maxUsages', max_usages))
            
        if offset_usages is not None:
            
            _query_params.append(('offsetUsages', offset_usages))
            
        if include_compute_servers is not None:
            
            _query_params.append(('includeComputeServers', include_compute_servers))
            
        if include_instances is not None:
            
            _query_params.append(('includeInstances', include_instances))
            
        if include_discovered_servers is not None:
            
            _query_params.append(('includeDiscoveredServers', include_discovered_servers))
            
        if include_load_balancers is not None:
            
            _query_params.append(('includeLoadBalancers', include_load_balancers))
            
        if include_virtual_images is not None:
            
            _query_params.append(('includeVirtualImages', include_virtual_images))
            
        if include_snapshots is not None:
            
            _query_params.append(('includeSnapshots', include_snapshots))
            
        if include_ms is not None:
            
            _query_params.append(('includeMs', include_ms))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/billing/zones',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


