# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from morpheus.models.list_logs200_response import ListLogs200Response

from morpheus.api_client import ApiClient, RequestSerialized
from morpheus.api_response import ApiResponse
from morpheus.rest import RESTResponseType


class LogsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def list_logs(
        self,
        max: Annotated[Optional[StrictInt], Field(description="Maximum number of records to return")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Offset records, the number of records to skip, for paginating requests")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order, the name of the property to sort by")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Sort direction, use 'desc' to reverse sort")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Alias for phrase")] = None,
        message: Annotated[Optional[StrictStr], Field(description="Filter by message")] = None,
        source_type: Annotated[Optional[StrictStr], Field(description="Filter by source type")] = None,
        type_code: Annotated[Optional[StrictStr], Field(description="Filter by code type")] = None,
        object_id: Annotated[Optional[StrictInt], Field(description="Filter by objectId")] = None,
        token: Annotated[Optional[StrictStr], Field(description="Filter by token")] = None,
        level: Annotated[Optional[StrictStr], Field(description="Filter by log level. Multiple values can be passed pipe delimited.")] = None,
        start_ms: Annotated[Optional[StrictInt], Field(description="Date filter in milliseconds (unix epoch), restricts query to only load logs updated more recently than the time specified.")] = None,
        end_ms: Annotated[Optional[StrictInt], Field(description="Date filter in milliseconds (unix epoch), restricts query to only load logs updated before the time specified.")] = None,
        start_date_time: Annotated[Optional[datetime], Field(description="Start Date timestamp (ISO 8601)")] = None,
        end_date_time: Annotated[Optional[datetime], Field(description="End Date timestamp (ISO 8601)")] = None,
        containers: Annotated[Optional[StrictInt], Field(description="The Container ID(s) for filtering. Accepts multiple values.")] = None,
        servers: Annotated[Optional[StrictInt], Field(description="The Server ID(s) for filtering. Accepts multiple values.")] = None,
        cluster_id: Annotated[Optional[StrictInt], Field(description="The Cluster ID(s) for filtering. Accepts multiple values.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListLogs200Response:
        """Retrieves Logs

        Retrieves logs based on filters provided. 

        :param max: Maximum number of records to return
        :type max: int
        :param offset: Offset records, the number of records to skip, for paginating requests
        :type offset: int
        :param sort: Sort order, the name of the property to sort by
        :type sort: str
        :param order: Sort direction, use 'desc' to reverse sort
        :type order: str
        :param query: Alias for phrase
        :type query: str
        :param message: Filter by message
        :type message: str
        :param source_type: Filter by source type
        :type source_type: str
        :param type_code: Filter by code type
        :type type_code: str
        :param object_id: Filter by objectId
        :type object_id: int
        :param token: Filter by token
        :type token: str
        :param level: Filter by log level. Multiple values can be passed pipe delimited.
        :type level: str
        :param start_ms: Date filter in milliseconds (unix epoch), restricts query to only load logs updated more recently than the time specified.
        :type start_ms: int
        :param end_ms: Date filter in milliseconds (unix epoch), restricts query to only load logs updated before the time specified.
        :type end_ms: int
        :param start_date_time: Start Date timestamp (ISO 8601)
        :type start_date_time: datetime
        :param end_date_time: End Date timestamp (ISO 8601)
        :type end_date_time: datetime
        :param containers: The Container ID(s) for filtering. Accepts multiple values.
        :type containers: int
        :param servers: The Server ID(s) for filtering. Accepts multiple values.
        :type servers: int
        :param cluster_id: The Cluster ID(s) for filtering. Accepts multiple values.
        :type cluster_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_logs_serialize(
            max=max,
            offset=offset,
            sort=sort,
            order=order,
            query=query,
            message=message,
            source_type=source_type,
            type_code=type_code,
            object_id=object_id,
            token=token,
            level=level,
            start_ms=start_ms,
            end_ms=end_ms,
            start_date_time=start_date_time,
            end_date_time=end_date_time,
            containers=containers,
            servers=servers,
            cluster_id=cluster_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListLogs200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_logs_with_http_info(
        self,
        max: Annotated[Optional[StrictInt], Field(description="Maximum number of records to return")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Offset records, the number of records to skip, for paginating requests")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order, the name of the property to sort by")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Sort direction, use 'desc' to reverse sort")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Alias for phrase")] = None,
        message: Annotated[Optional[StrictStr], Field(description="Filter by message")] = None,
        source_type: Annotated[Optional[StrictStr], Field(description="Filter by source type")] = None,
        type_code: Annotated[Optional[StrictStr], Field(description="Filter by code type")] = None,
        object_id: Annotated[Optional[StrictInt], Field(description="Filter by objectId")] = None,
        token: Annotated[Optional[StrictStr], Field(description="Filter by token")] = None,
        level: Annotated[Optional[StrictStr], Field(description="Filter by log level. Multiple values can be passed pipe delimited.")] = None,
        start_ms: Annotated[Optional[StrictInt], Field(description="Date filter in milliseconds (unix epoch), restricts query to only load logs updated more recently than the time specified.")] = None,
        end_ms: Annotated[Optional[StrictInt], Field(description="Date filter in milliseconds (unix epoch), restricts query to only load logs updated before the time specified.")] = None,
        start_date_time: Annotated[Optional[datetime], Field(description="Start Date timestamp (ISO 8601)")] = None,
        end_date_time: Annotated[Optional[datetime], Field(description="End Date timestamp (ISO 8601)")] = None,
        containers: Annotated[Optional[StrictInt], Field(description="The Container ID(s) for filtering. Accepts multiple values.")] = None,
        servers: Annotated[Optional[StrictInt], Field(description="The Server ID(s) for filtering. Accepts multiple values.")] = None,
        cluster_id: Annotated[Optional[StrictInt], Field(description="The Cluster ID(s) for filtering. Accepts multiple values.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListLogs200Response]:
        """Retrieves Logs

        Retrieves logs based on filters provided. 

        :param max: Maximum number of records to return
        :type max: int
        :param offset: Offset records, the number of records to skip, for paginating requests
        :type offset: int
        :param sort: Sort order, the name of the property to sort by
        :type sort: str
        :param order: Sort direction, use 'desc' to reverse sort
        :type order: str
        :param query: Alias for phrase
        :type query: str
        :param message: Filter by message
        :type message: str
        :param source_type: Filter by source type
        :type source_type: str
        :param type_code: Filter by code type
        :type type_code: str
        :param object_id: Filter by objectId
        :type object_id: int
        :param token: Filter by token
        :type token: str
        :param level: Filter by log level. Multiple values can be passed pipe delimited.
        :type level: str
        :param start_ms: Date filter in milliseconds (unix epoch), restricts query to only load logs updated more recently than the time specified.
        :type start_ms: int
        :param end_ms: Date filter in milliseconds (unix epoch), restricts query to only load logs updated before the time specified.
        :type end_ms: int
        :param start_date_time: Start Date timestamp (ISO 8601)
        :type start_date_time: datetime
        :param end_date_time: End Date timestamp (ISO 8601)
        :type end_date_time: datetime
        :param containers: The Container ID(s) for filtering. Accepts multiple values.
        :type containers: int
        :param servers: The Server ID(s) for filtering. Accepts multiple values.
        :type servers: int
        :param cluster_id: The Cluster ID(s) for filtering. Accepts multiple values.
        :type cluster_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_logs_serialize(
            max=max,
            offset=offset,
            sort=sort,
            order=order,
            query=query,
            message=message,
            source_type=source_type,
            type_code=type_code,
            object_id=object_id,
            token=token,
            level=level,
            start_ms=start_ms,
            end_ms=end_ms,
            start_date_time=start_date_time,
            end_date_time=end_date_time,
            containers=containers,
            servers=servers,
            cluster_id=cluster_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListLogs200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_logs_without_preload_content(
        self,
        max: Annotated[Optional[StrictInt], Field(description="Maximum number of records to return")] = None,
        offset: Annotated[Optional[StrictInt], Field(description="Offset records, the number of records to skip, for paginating requests")] = None,
        sort: Annotated[Optional[StrictStr], Field(description="Sort order, the name of the property to sort by")] = None,
        order: Annotated[Optional[StrictStr], Field(description="Sort direction, use 'desc' to reverse sort")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Alias for phrase")] = None,
        message: Annotated[Optional[StrictStr], Field(description="Filter by message")] = None,
        source_type: Annotated[Optional[StrictStr], Field(description="Filter by source type")] = None,
        type_code: Annotated[Optional[StrictStr], Field(description="Filter by code type")] = None,
        object_id: Annotated[Optional[StrictInt], Field(description="Filter by objectId")] = None,
        token: Annotated[Optional[StrictStr], Field(description="Filter by token")] = None,
        level: Annotated[Optional[StrictStr], Field(description="Filter by log level. Multiple values can be passed pipe delimited.")] = None,
        start_ms: Annotated[Optional[StrictInt], Field(description="Date filter in milliseconds (unix epoch), restricts query to only load logs updated more recently than the time specified.")] = None,
        end_ms: Annotated[Optional[StrictInt], Field(description="Date filter in milliseconds (unix epoch), restricts query to only load logs updated before the time specified.")] = None,
        start_date_time: Annotated[Optional[datetime], Field(description="Start Date timestamp (ISO 8601)")] = None,
        end_date_time: Annotated[Optional[datetime], Field(description="End Date timestamp (ISO 8601)")] = None,
        containers: Annotated[Optional[StrictInt], Field(description="The Container ID(s) for filtering. Accepts multiple values.")] = None,
        servers: Annotated[Optional[StrictInt], Field(description="The Server ID(s) for filtering. Accepts multiple values.")] = None,
        cluster_id: Annotated[Optional[StrictInt], Field(description="The Cluster ID(s) for filtering. Accepts multiple values.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieves Logs

        Retrieves logs based on filters provided. 

        :param max: Maximum number of records to return
        :type max: int
        :param offset: Offset records, the number of records to skip, for paginating requests
        :type offset: int
        :param sort: Sort order, the name of the property to sort by
        :type sort: str
        :param order: Sort direction, use 'desc' to reverse sort
        :type order: str
        :param query: Alias for phrase
        :type query: str
        :param message: Filter by message
        :type message: str
        :param source_type: Filter by source type
        :type source_type: str
        :param type_code: Filter by code type
        :type type_code: str
        :param object_id: Filter by objectId
        :type object_id: int
        :param token: Filter by token
        :type token: str
        :param level: Filter by log level. Multiple values can be passed pipe delimited.
        :type level: str
        :param start_ms: Date filter in milliseconds (unix epoch), restricts query to only load logs updated more recently than the time specified.
        :type start_ms: int
        :param end_ms: Date filter in milliseconds (unix epoch), restricts query to only load logs updated before the time specified.
        :type end_ms: int
        :param start_date_time: Start Date timestamp (ISO 8601)
        :type start_date_time: datetime
        :param end_date_time: End Date timestamp (ISO 8601)
        :type end_date_time: datetime
        :param containers: The Container ID(s) for filtering. Accepts multiple values.
        :type containers: int
        :param servers: The Server ID(s) for filtering. Accepts multiple values.
        :type servers: int
        :param cluster_id: The Cluster ID(s) for filtering. Accepts multiple values.
        :type cluster_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_logs_serialize(
            max=max,
            offset=offset,
            sort=sort,
            order=order,
            query=query,
            message=message,
            source_type=source_type,
            type_code=type_code,
            object_id=object_id,
            token=token,
            level=level,
            start_ms=start_ms,
            end_ms=end_ms,
            start_date_time=start_date_time,
            end_date_time=end_date_time,
            containers=containers,
            servers=servers,
            cluster_id=cluster_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListLogs200Response",
            '4XX': "ListActivity4XXResponse",
            '5XX': "ListActivity5XXResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_logs_serialize(
        self,
        max,
        offset,
        sort,
        order,
        query,
        message,
        source_type,
        type_code,
        object_id,
        token,
        level,
        start_ms,
        end_ms,
        start_date_time,
        end_date_time,
        containers,
        servers,
        cluster_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if max is not None:
            
            _query_params.append(('max', max))
            
        if offset is not None:
            
            _query_params.append(('offset', offset))
            
        if sort is not None:
            
            _query_params.append(('sort', sort))
            
        if order is not None:
            
            _query_params.append(('order', order))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if message is not None:
            
            _query_params.append(('message', message))
            
        if source_type is not None:
            
            _query_params.append(('sourceType', source_type))
            
        if type_code is not None:
            
            _query_params.append(('typeCode', type_code))
            
        if object_id is not None:
            
            _query_params.append(('objectId', object_id))
            
        if token is not None:
            
            _query_params.append(('token', token))
            
        if level is not None:
            
            _query_params.append(('level', level))
            
        if start_ms is not None:
            
            _query_params.append(('startMs', start_ms))
            
        if end_ms is not None:
            
            _query_params.append(('endMs', end_ms))
            
        if start_date_time is not None:
            if isinstance(start_date_time, datetime):
                _query_params.append(
                    (
                        'startDateTime',
                        start_date_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('startDateTime', start_date_time))
            
        if end_date_time is not None:
            if isinstance(end_date_time, datetime):
                _query_params.append(
                    (
                        'endDateTime',
                        end_date_time.strftime(
                            self.api_client.configuration.datetime_format
                        )
                    )
                )
            else:
                _query_params.append(('endDateTime', end_date_time))
            
        if containers is not None:
            
            _query_params.append(('containers', containers))
            
        if servers is not None:
            
            _query_params.append(('servers', servers))
            
        if cluster_id is not None:
            
            _query_params.append(('clusterId', cluster_id))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'bearerAuth'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/logs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


