# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_budgets_request_budget_forecast_type import AddBudgetsRequestBudgetForecastType
from typing import Optional, Set
from typing_extensions import Self

class AddBudgetsRequestBudget(BaseModel):
    """
    AddBudgetsRequestBudget
    """ # noqa: E501
    name: StrictStr
    description: Optional[StrictStr] = None
    scope: Optional[StrictStr] = 'account'
    period: Optional[StrictStr] = 'year'
    year: Optional[StrictInt] = None
    start_date: Optional[datetime] = Field(default=None, alias="startDate")
    end_date: Optional[datetime] = Field(default=None, alias="endDate")
    interval: Optional[StrictStr] = 'year'
    scope_tenant_id: Optional[StrictInt] = Field(default=None, description="The Tenant ID to scope to, for use with ``scope``=tenant ", alias="scopeTenantId")
    scope_group_id: Optional[StrictInt] = Field(default=None, description="The Tenant ID to scope to, for use with ``scope``=group  ", alias="scopeGroupId")
    scope_cloud_id: Optional[StrictInt] = Field(default=None, description="The Tenant ID to scope to, for use with ``scope``=cloud ", alias="scopeCloudId")
    scope_user_id: Optional[StrictInt] = Field(default=None, description="The Tenant ID to scope to, for use with ``scope``=user ", alias="scopeUserId")
    costs: Optional[List[StrictInt]] = None
    enabled: Optional[StrictBool] = True
    forecast_type: Optional[AddBudgetsRequestBudgetForecastType] = Field(default=None, alias="forecastType")
    __properties: ClassVar[List[str]] = ["name", "description", "scope", "period", "year", "startDate", "endDate", "interval", "scopeTenantId", "scopeGroupId", "scopeCloudId", "scopeUserId", "costs", "enabled", "forecastType"]

    @field_validator('scope')
    def scope_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['account', 'group', 'cloud', 'user']):
            raise ValueError("must be one of enum values ('account', 'group', 'cloud', 'user')")
        return value

    @field_validator('interval')
    def interval_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['year', 'quarter', 'month']):
            raise ValueError("must be one of enum values ('year', 'quarter', 'month')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddBudgetsRequestBudget from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of forecast_type
        if self.forecast_type:
            _dict['forecastType'] = self.forecast_type.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddBudgetsRequestBudget from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "scope": obj.get("scope") if obj.get("scope") is not None else 'account',
            "period": obj.get("period") if obj.get("period") is not None else 'year',
            "year": obj.get("year"),
            "startDate": obj.get("startDate"),
            "endDate": obj.get("endDate"),
            "interval": obj.get("interval") if obj.get("interval") is not None else 'year',
            "scopeTenantId": obj.get("scopeTenantId"),
            "scopeGroupId": obj.get("scopeGroupId"),
            "scopeCloudId": obj.get("scopeCloudId"),
            "scopeUserId": obj.get("scopeUserId"),
            "costs": obj.get("costs"),
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else True,
            "forecastType": AddBudgetsRequestBudgetForecastType.from_dict(obj["forecastType"]) if obj.get("forecastType") is not None else None
        })
        return _obj


