# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, Dict, Optional
from morpheus.models.amazon_instance_configuration import AmazonInstanceConfiguration
from morpheus.models.azure_instance_configuration import AzureInstanceConfiguration
from morpheus.models.google_cloud_instance_configuration import GoogleCloudInstanceConfiguration
from morpheus.models.vm_ware_instance_configuration import VMWareInstanceConfiguration
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

ADDCATALOGITEMTYPEREQUESTCATALOGITEMTYPEONEOFCONFIGCONFIG_ANY_OF_SCHEMAS = ["AmazonInstanceConfiguration", "AzureInstanceConfiguration", "GoogleCloudInstanceConfiguration", "VMWareInstanceConfiguration", "object"]

class AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigConfig(BaseModel):
    """
    AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigConfig
    """

    # data type: AzureInstanceConfiguration
    anyof_schema_1_validator: Optional[AzureInstanceConfiguration] = None
    # data type: VMWareInstanceConfiguration
    anyof_schema_2_validator: Optional[VMWareInstanceConfiguration] = None
    # data type: GoogleCloudInstanceConfiguration
    anyof_schema_3_validator: Optional[GoogleCloudInstanceConfiguration] = None
    # data type: AmazonInstanceConfiguration
    anyof_schema_4_validator: Optional[AmazonInstanceConfiguration] = None
    # data type: object
    anyof_schema_5_validator: Optional[Dict[str, Any]] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[AmazonInstanceConfiguration, AzureInstanceConfiguration, GoogleCloudInstanceConfiguration, VMWareInstanceConfiguration, object]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "AmazonInstanceConfiguration", "AzureInstanceConfiguration", "GoogleCloudInstanceConfiguration", "VMWareInstanceConfiguration", "object" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigConfig.model_construct()
        error_messages = []
        # validate data type: AzureInstanceConfiguration
        if not isinstance(v, AzureInstanceConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AzureInstanceConfiguration`")
        else:
            return v

        # validate data type: VMWareInstanceConfiguration
        if not isinstance(v, VMWareInstanceConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `VMWareInstanceConfiguration`")
        else:
            return v

        # validate data type: GoogleCloudInstanceConfiguration
        if not isinstance(v, GoogleCloudInstanceConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GoogleCloudInstanceConfiguration`")
        else:
            return v

        # validate data type: AmazonInstanceConfiguration
        if not isinstance(v, AmazonInstanceConfiguration):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AmazonInstanceConfiguration`")
        else:
            return v

        # validate data type: object
        try:
            instance.anyof_schema_5_validator = v
            return v
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigConfig with anyOf schemas: AmazonInstanceConfiguration, AzureInstanceConfiguration, GoogleCloudInstanceConfiguration, VMWareInstanceConfiguration, object. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[AzureInstanceConfiguration] = None
        try:
            instance.actual_instance = AzureInstanceConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[VMWareInstanceConfiguration] = None
        try:
            instance.actual_instance = VMWareInstanceConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[GoogleCloudInstanceConfiguration] = None
        try:
            instance.actual_instance = GoogleCloudInstanceConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[AmazonInstanceConfiguration] = None
        try:
            instance.actual_instance = AmazonInstanceConfiguration.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # deserialize data into object
        try:
            # validation
            instance.anyof_schema_5_validator = json.loads(json_str)
            # assign value to actual_instance
            instance.actual_instance = instance.anyof_schema_5_validator
            return instance
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigConfig with anyOf schemas: AmazonInstanceConfiguration, AzureInstanceConfiguration, GoogleCloudInstanceConfiguration, VMWareInstanceConfiguration, object. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], AmazonInstanceConfiguration, AzureInstanceConfiguration, GoogleCloudInstanceConfiguration, VMWareInstanceConfiguration, object]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


