# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_network_interfaces_inner_network import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigNetworkInterfacesInnerNetwork
from typing import Optional, Set
from typing_extensions import Self

class AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigNetworkInterfacesInnerNetworkInterfacesInner(BaseModel):
    """
    AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigNetworkInterfacesInnerNetworkInterfacesInner
    """ # noqa: E501
    network: AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigNetworkInterfacesInnerNetwork
    network_interface_type_id: Optional[StrictInt] = Field(default=None, description="The id of type of the network interface.", alias="networkInterfaceTypeId")
    ip_mode: Optional[StrictStr] = Field(default='dhcp', description="The mode for determining ip address. Use 'static' when specifying an ipAddress, otherwise 'dhcp' is used.", alias="ipMode")
    ip_address: Optional[StrictStr] = Field(default=None, description="The ip address. Not applicable when using DHCP or IP Pools.", alias="ipAddress")
    mac_address: Optional[StrictStr] = Field(default=None, description="The MAC address.", alias="macAddress")
    id: Optional[StrictInt] = Field(default=None, description="The interface id. Applicable when resizing and you want to identify an interface to update that already exists.")
    __properties: ClassVar[List[str]] = ["network", "networkInterfaceTypeId", "ipMode", "ipAddress", "macAddress", "id"]

    @field_validator('ip_mode')
    def ip_mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['static', 'dhcp']):
            raise ValueError("must be one of enum values ('static', 'dhcp')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigNetworkInterfacesInnerNetworkInterfacesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of network
        if self.network:
            _dict['network'] = self.network.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigNetworkInterfacesInnerNetworkInterfacesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "network": AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigNetworkInterfacesInnerNetwork.from_dict(obj["network"]) if obj.get("network") is not None else None,
            "networkInterfaceTypeId": obj.get("networkInterfaceTypeId"),
            "ipMode": obj.get("ipMode") if obj.get("ipMode") is not None else 'dhcp',
            "ipAddress": obj.get("ipAddress"),
            "macAddress": obj.get("macAddress"),
            "id": obj.get("id")
        })
        return _obj


