# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_catalog_item_type_request_catalog_item_type_one_of_config_volumes_inner_datastore_id import AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigVolumesInnerDatastoreId
from typing import Optional, Set
from typing_extensions import Self

class AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigVolumesInner(BaseModel):
    """
    AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigVolumesInner
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=-1, description="The id for the LV configuration being created.")
    root_volume: Optional[StrictBool] = Field(default=True, description="If set to false then a non-root LV will be created.", alias="rootVolume")
    name: Optional[StrictStr] = Field(default='root', description="Name/type of the LV being created.")
    size: Optional[StrictInt] = Field(default=None, description="Size of the LV to be created in GBs.  Uses default from service plan.")
    size_id: Optional[StrictInt] = Field(default=None, description="Can be used to select pre-existing LV choices from Morpheus.", alias="sizeId")
    storage_type: Optional[StrictInt] = Field(default=None, description="Identifier for LV type", alias="storageType")
    datastore_id: Optional[AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigVolumesInnerDatastoreId] = Field(default=None, alias="datastoreId")
    controller_mount_point: Optional[StrictStr] = Field(default=None, description="The controller mount point specification for this volume in the format: `\"id:busNumber:typeId:unitNumber\"` For new storage controllers the id is passed as -1, so an example value would be: `\"-1:1:6:0\"` which translates to id: -1 (new), busNumber: 1, storage controller type id: 6 (SCSI VMware Paravirtual), unit number: 0. The current list of storage controllers is returned for instances and servers for determining existing id values. Use `/api/provision-types?code=vmware` to see the available `controllerTypes` for vmware.", alias="controllerMountPoint")
    __properties: ClassVar[List[str]] = ["id", "rootVolume", "name", "size", "sizeId", "storageType", "datastoreId", "controllerMountPoint"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigVolumesInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of datastore_id
        if self.datastore_id:
            _dict['datastoreId'] = self.datastore_id.to_dict()
        # set to None if size_id (nullable) is None
        # and model_fields_set contains the field
        if self.size_id is None and "size_id" in self.model_fields_set:
            _dict['sizeId'] = None

        # set to None if storage_type (nullable) is None
        # and model_fields_set contains the field
        if self.storage_type is None and "storage_type" in self.model_fields_set:
            _dict['storageType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigVolumesInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id") if obj.get("id") is not None else -1,
            "rootVolume": obj.get("rootVolume") if obj.get("rootVolume") is not None else True,
            "name": obj.get("name") if obj.get("name") is not None else 'root',
            "size": obj.get("size"),
            "sizeId": obj.get("sizeId"),
            "storageType": obj.get("storageType"),
            "datastoreId": AddCatalogItemTypeRequestCatalogItemTypeOneOfConfigVolumesInnerDatastoreId.from_dict(obj["datastoreId"]) if obj.get("datastoreId") is not None else None,
            "controllerMountPoint": obj.get("controllerMountPoint")
        })
        return _obj


