# coding: utf-8

"""
    Morpheus API

    Morpheus is a powerful cloud management tool that provides provisioning, monitoring, logging, backups, and application deployment strategies.  This document describes the Morpheus API protocol and the available endpoints. Sections are organized in the same manner as they appear in the Morpheus UI.

    The version of the OpenAPI document: 8.0.8
    Contact: dev@morpheusdata.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from morpheus.models.add_checks_request_check_one_of4_check_type import AddChecksRequestCheckOneOf4CheckType
from typing import Optional, Set
from typing_extensions import Self

class AddChecksRequestCheckOneOf4(BaseModel):
    """
    A push Check is not polled regularly by the standard monitoring system. Instead it is expected that an external API push updates as to the status of the check timed closely with the configured check interval setting. This is used to throttle the push from performing too many status updates. To push an update using the api key one must send a json payload like so: `curl -XPOST https://<morpheus url>/api/monitoring/push?apiKey=<apiKey> -H 'Content-Type: application/json' -d '{\"success\":true, \"message\": \"any comment goes here\"}'` The API Key will be returned on successful creation or can be found by getting this check. 
    """ # noqa: E501
    name: Optional[StrictStr] = Field(default=None, description="Unique name scoped to your account for the check")
    description: Optional[StrictStr] = Field(default=None, description="Optional description field")
    check_type: Optional[AddChecksRequestCheckOneOf4CheckType] = Field(default=None, alias="checkType")
    check_interval: Optional[StrictInt] = Field(default=300, description="Number of seconds you want between check executions (minimum value is 60, depending on your subscription plan)", alias="checkInterval")
    in_uptime: Optional[StrictBool] = Field(default=True, description="Used to determine if check should affect account wide availability calculations", alias="inUptime")
    active: Optional[StrictBool] = Field(default=True, description="Used to determine if check should be scheduled to execute")
    severity: Optional[StrictStr] = Field(default='critical', description="Severity level threshold for sending notifications.")
    __properties: ClassVar[List[str]] = ["name", "description", "checkType", "checkInterval", "inUptime", "active", "severity"]

    @field_validator('severity')
    def severity_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['info', 'warning', 'critical']):
            raise ValueError("must be one of enum values ('info', 'warning', 'critical')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AddChecksRequestCheckOneOf4 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of check_type
        if self.check_type:
            _dict['checkType'] = self.check_type.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AddChecksRequestCheckOneOf4 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "checkType": AddChecksRequestCheckOneOf4CheckType.from_dict(obj["checkType"]) if obj.get("checkType") is not None else None,
            "checkInterval": obj.get("checkInterval") if obj.get("checkInterval") is not None else 300,
            "inUptime": obj.get("inUptime") if obj.get("inUptime") is not None else True,
            "active": obj.get("active") if obj.get("active") is not None else True,
            "severity": obj.get("severity") if obj.get("severity") is not None else 'critical'
        })
        return _obj


